% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{create_var_attribute_definition}
\alias{create_var_attribute_definition}
\title{Create variable attribute definition}
\usage{
create_var_attribute_definition(type = 2L,
  type_description = "accumulated over the preceding interval",
  dat_type = "der",
  dat_type_description = "AWAP data interpolated from observations",
  location_type = "Point")
}
\arguments{
\item{type}{A data type identifier, as a coded description.}

\item{type_description}{description of this data type identifier.}

\item{dat_type}{a character, the type of data stored in this variable}

\item{dat_type_description}{a character, human readable description of the data stored in this variable}

\item{location_type}{a character, type of location, e.g. 'Point'}
}
\value{
a list of attributes, describing the type of variable stored
}
\description{
Create variable attribute definition
}
\examples{
va <- create_var_attribute_definition(type=2L, 
  type_description='accumulated over the preceding interval', location_type='Point')
vdef <- create_variable_definition(name='rain_sim', 
  longname='Rainfall ensemble forecast derived from some prediction', 
  units='mm', missval=-9999.0, precision='double', 
  var_attribute=va)

}
