% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{create_efts_variables}
\alias{create_efts_variables}
\title{Create netCDF variables according to the definition}
\usage{
create_efts_variables(data_var_def, time_dim_info, num_stations, lead_length,
  ensemble_length, optional_vars, lead_time_tstep)
}
\arguments{
\item{data_var_def}{a list, with each item itself a list suitable as a variable definition argument to create_data_variable}

\item{time_dim_info}{a list with the units and values defining the time dimension of the data set}

\item{num_stations}{number of (gauging) stations identifying points in the data set}

\item{lead_length}{length of the lead forecasting time series.}

\item{ensemble_length}{number of ensembles, i.e. number of forecasts for each point on the main time axis of the data set}

\item{optional_vars}{a data frame defining optional netCDF variables. For a templated default see 
\code{\link{default_optional_variable_definitions_v2_0}} and 
\url{https://github.com/jmp75/efts/blob/107c553045a37e6ef36b2eababf6a299e7883d50/docs/netcdf_for_water_forecasting.md#optional-variables}}

\item{lead_time_tstep}{string specifying the time step of the forecast lead length.}
}
\description{
Create netCDF variables according to the definition
}
\seealso{
See
   \code{\link{create_efts}} for examples
}
