% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eeptools-package.r
\docType{data}
\name{stuatt}
\alias{stuatt}
\title{Student Attributes from the Strategic Data Project Toolkit}
\format{A data frame with 87534 observations on the following 9 variables.
\describe{
  \item{\code{sid}}{a numeric vector of the unique student ID}
  \item{\code{school_year}}{a numeric vector of the school year}
  \item{\code{male}}{a numeric vector indicating 1 = male}
  \item{\code{race_ethnicity}}{a factor with levels \code{A} \code{B} \code{H} \code{M/O} \code{W}}
  \item{\code{birth_date}}{a numeric vector of the student birthdate}
  \item{\code{first_9th_school_year_reported}}{a numeric vector of the first year a student is reported in 9th grade}
  \item{\code{hs_diploma}}{a numeric vector}
  \item{\code{hs_diploma_type}}{a factor with levels \code{} \code{Alternative Diploma} \code{College Prep Diploma} \code{Standard Diploma}}
  \item{\code{hs_diploma_date}}{a factor with levels \code{} \code{12/2/2008} \code{12/21/2008} \code{4/14/2008} \code{4/18/2008} ...}
  }}
\source{
Available from the Strategic Data Project online at 
\url{http://sdp.cepr.harvard.edu/toolkit-effective-data-use}
}
\usage{
stuatt
}
\description{
A synthetic dataset of student attributes from the Strategic Data 
Project which includes records with errors to practice data cleaning and 
implementing business rules for consistency in data.
}
\details{
This is the non-clean version of the data to allow for implementing 
business rules to clean data.
}
\examples{
data(stuatt)
head(stuatt)
}
\references{
Visit the Strategic Data Project online at:  \url{http://sdp.cepr.harvard.edu/}
}
\keyword{datasets}
