% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_cut}
\alias{eem_cut}
\title{Cut emission and/or excitation wavelengths from EEMs}
\usage{
eem_cut(eem, ex, em)
}
\arguments{
\item{eem}{Either an object of class \code{eem} or \code{eemlist}.}

\item{ex}{A numeric vector of excitation wavelengths to be removed.}

\item{em}{A numeric vector of emission wavelengths to be removed.}
}
\value{
Either an object of class \code{eem} or \code{eemlist}.
}
\description{
Cut emission and/or excitation wavelengths from EEMs
}
\examples{
# Open the fluorescence eem
file <- system.file("extdata/cary/eem/", "sample1.csv", package = "eemR")

eem <- eem_read(file)
plot(eem)

# Cut few excitation wavelengths
eem <- eem_cut(eem, ex = c(220, 225, 230, 230))
plot(eem)
}

