% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eefAnalytics_03_2017.r
\name{mlmBayes}
\alias{mlmBayes}
\title{Bayesia multilevel analysis of randomised educatuon trials using vague priors.}
\usage{
mlmBayes(formula, random, intervention, nSim, data)
}
\arguments{
\item{formula}{the model to be analysed. It is of the form y ~ x1+x2+.... Where y is the outcome variable and Xs are the predictors.}

\item{random}{a string variable specifying the "clustering variable" as contained in the data. See example below}

\item{intervention}{a string variable specifying the "intervention variable" as appeared in the formula. See example below}

\item{nSim}{number of MCMC iterations. A minimum of 10,000 is recommended.}

\item{data}{data frame containing the data to be analysed.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{Beta}. Estimates and confidence intervals for preditors specified in the model.
\item \code{ES}. Hedges' g effect size for the intervention(s). If nBoot is not specified, the confidence intervals are 95% CIs based on standard errors. If nBoot is specified, they are non-parametric bootstrapped confidence intervals.
\item \code{covParm}. Vector of variance decomposition into between cluster variance (Schools) and within cluster variance (Pupils). It also contains the intral-cluster correlation (ICC).
\item \code{SchEffects}. Random intercepts for clusters, e.g schools.
\item \code{ProbES}. A maxtrix containing the probability of observing effect size greater than a pre-specified threshold. 
}
}
\description{
\code{mlmBayes} performs analysis of randomised eduation trials using multilevel model under Bayesian framework 
assuming vague priors.
}
\examples{
if(interactive()){
  
data(crtData)

########################################################
## Bayesian analysis of cluster randomised trials     ##
########################################################

output <- mlmBayes(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",nSim=10000,data=crtData)

### Fixed effects
beta <- output$Beta
beta

### Effect size
ES1 <- output$ES
ES1

## Covariance matrix
covParm <- output$covParm
covParm

### plot random effects for schools

plot(output)

### plot posterior probability of an effect size to be bigger than a pre-specified threshold

plot(output,group=1)
}
}

