% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFilingsHTML.R
\name{getFilingsHTML}
\alias{getFilingsHTML}
\title{Get HTML view of EDGAR filings}
\usage{
getFilingsHTML(cik.no, form.type, filing.year, quarter)
}
\arguments{
\item{cik.no}{vector of CIK number of firms in integer format. Suppress leading 
zeroes from CIKs. Keep cik.no = 'ALL' if needs to download for all CIKs.}

\item{form.type}{character vector containing form type to be downloaded. 
form.type = 'ALL' if need to download all forms.}

\item{filing.year}{vector of four digit numeric year}

\item{quarter}{vector of one digit quarter integer number. By deault, it is kept
as c(1 ,2, 3, 4).}
}
\value{
Function saves EDGAR filings in HTML format and returns filing information 
in dataframe format.
}
\description{
\code{getFilingsHTML} retrieves complete EDGAR filings and store them in
HTML format for view.
}
\details{
getFilingsHTML function takes CIKs, form type, filing year, and quarter of the 
filing as input. The function imports edgar filings downloaded 
via \link[edgar]{getFilings} function; otherwise, it downloads the filings which are 
not already been downloaded. It then reads the downloaded filing, scraps main
body the filing, and save the filing content in 'Edgar filings_HTML view' 
directory in HTML format. The new directory 'Edgar filings_HTML view' will be 
automatically created by this function. This function only gives a view of the 
main body of the filing, exhibit and other supporting documents will not 
appear in HTML file.
}
\examples{
\dontrun{

output <- getFilingsHTML(cik.no = c(1000180, 38079), c('10-K','10-Q'), 
                         2006, quarter = c(1, 2, 3))

## download '10-Q' and '10-K' filings filed by the firm with 
CIK = 1000180 in quarters 1,2, and 3 of the year 2006. These filings 
will be stored in the current working directory.

}
}
