% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing_time.R
\name{processing_time}
\alias{processing_time}
\alias{processing_time.eventlog}
\alias{processing_time.grouped_eventlog}
\title{Metric: Processing time}
\usage{
processing_time(eventlog, level, append, append_column, units, ...)

\method{processing_time}{eventlog}(eventlog, level = c("log", "trace", "case",
  "activity", "resource", "resource-activity"), append = F,
  append_column = NULL, units = c("days", "hours", "mins", "secs", "week"),
  ...)

\method{processing_time}{grouped_eventlog}(eventlog, level = c("log", "trace",
  "case", "activity", "resource", "resource-activity"), append = F,
  append_column = NULL, units = c("hours", "days", "weeks", "mins"), ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{level}{Level of granularity for the analysis: log,  case, trace, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{append_column}{Which of the output columns to append to log, if append = T. Default column depends on chosen level.}

\item{units}{Time units to be used}

\item{...}{Deprecated arguments}
}
\description{
Provides summary statistics about the processing time of the process.
}
\details{
In contrast to the throughput time of the cases in an event log, the metrics concerning
 the active time or the actual processing time provide summary statistics on the
 processing time of events on the level of the complete event log, the specific cases,
  traces, the activities, and the resource-activity combinations.

\itemize{
  \item On log level, this metric calculates the summary statistics of the actual processing time per case,
  summarised over the complete event log.
  \item On case level, a list of cases with their processing time are provided.
  \item On trace level, the summary statistics of processing time
  can be calculated for each possible sequence of activities that
  appears in the event log.
  \item Duration can also be calculated on the level
  of each activity. For each activity, an overview of the average processing time
  -or the service time- of this activity can be of interest.
  \item We can also look at the processing time per case
  on the level of each separate resource. This way, a company gets an overview of
  the amount of time each resource spends on a case and which resources spend
  more time on cases than others.
  \item On the resource-activity level, finally,
  we can have a look at the efficiency of resources by looking at the combination
  of each resource with each activity.
  }
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Compute processing time for event log

\item \code{grouped_eventlog}: Compute processing time on grouped eventlog
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
