% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{E_num}
\alias{E_num}
\title{Get the Eddington number for cycling}
\usage{
E_num(rides)
}
\arguments{
\item{rides}{A vector of mileage, where each element represents a single
day.}
}
\value{
An integer which is the Eddington cycling number for the
  data provided.
}
\description{
Gets the \href{https://en.wikipedia.org/wiki/Arthur_Eddington#Eddington_number_for_cycling}{Eddington number for cycling}.
The Eddington Number for cycling, \emph{E}, is the
maximum number where a cyclist has ridden \emph{E} miles in \emph{E} days.
}
\details{
The Eddington Number for cycling is related to computing the rank of an
integer partition, which is the same as computing the side length of its
\href{https://en.wikipedia.org/wiki/Durfee_square}{Durfee square}. Another
relevant application of this metric is computing the
\href{https://doi.org/10.1073/pnas.0507655102}{Hirsch index} for
publications.

This is not to be confused with the
\href{https://en.wikipedia.org/wiki/Eddington_number}{Eddington Number in
astrophysics}, \eqn{N_{Edd}}, which represents the number of protons in the
observable universe.
}
\examples{
# Randomly generate a set of 15 rides
rides <- rgamma(15, shape = 2, scale = 10)

# View the rides sorted in decreasing order
setNames(sort(rides, decreasing = TRUE), seq_along(rides))

# Get the Eddington number
E_num(rides)
}
\seealso{
\code{\link{E_cum}}, \code{\link{E_next}}, \code{\link{E_req}},
  \code{\link{E_sat}}
}
