
<!-- README.md is generated from README.Rmd. Please edit that file -->

# edbuildmapr

<!-- badges: start -->

<!-- badges: end -->

The goal of `edbuildmapr` is to simplify the use of school district
shapefiles. The package import US Census Bureau, Education Demographic
and Geographic Estimates Program, Composite School District Boundaries
Files for 2013-2017 with the option to attach EdBuild’s master dataset
of school district finance, student demographics, and community economic
indicators for every school district in the United States. The master
dataset is built from the US Census, Annual Survey of School System
Finances (F33) and joins data from the National Center for Education
Statistics, Common Core of Data; the US Census, Small Area Income and
Poverty Estimates; and the US Census, Education Demographic and
Geographic Estimates. Additional functions in the package create a
dataset of all school district neighbors as either a dataframe or a
shapefile and maps of selected districts at the state or neighbor level
symbolized by a selected variable in EdBuild’s master dataset. For full
details about EdBuild’s data processing please see EdBuild (2019)
[Dividing
Lines](https://edbuild.org/content/dividing-lines/main/methodology).

## Installation

You can install the released version of edbuildmapr from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("edbuildmapr")
```

## Example

To import school district spatial data for all districts with EdBuild’s
master data:

``` r
library(edbuildmapr)
## import school district shapefile for the year 2017 with EdBuild's master dataset attached. 
sd_shp_17 <- sd_shapepull("2017", with_data = TRUE)
#> Reading layer `shapefile_1718_4269' from data source `/private/var/folders/5n/cz5rxt2d02jcqlt7q25sy37m0000gp/T/RtmpIfj79x/file7dc910723388/shapefile_1718_4269.shp' using driver `ESRI Shapefile'
#> Simple feature collection with 13330 features and 6 fields
#> geometry type:  MULTIPOLYGON
#> dimension:      XY
#> bbox:           xmin: -179.1686 ymin: 18.91382 xmax: 179.7487 ymax: 71.38881
#> epsg (SRID):    4269
#> proj4string:    +proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs
#> NOTE::This shapefile has been simplified to make analysis quicker. For final vizualizations, please use the unsimplified shapefiles available through NCES.

str(sd_shp_17)
#> Classes 'sf' and 'data.frame':   13309 obs. of  46 variables:
#>  $ FIPS       : chr  "04" "04" "04" "04" ...
#>  $ GEOID      : chr  "0407530" "0401740" "0401160" "0400720" ...
#>  $ NAME       : chr  "Santa Cruz Valley Union High School District" "Casa Grande Union High School District" "Bicentennial Union High School District" "Antelope Union High School District" ...
#>  $ sdType     : chr  "secon" "secon" "secon" "secon" ...
#>  $ State      : chr  "Arizona" "Arizona" "Arizona" "Arizona" ...
#>  $ Postal     : chr  "AZ" "AZ" "AZ" "AZ" ...
#>  $ CONUM      : int  4021 4021 4012 4027 4027 4015 4013 4013 4013 4013 ...
#>  $ ENROLL     : int  453 3638 123 246 11055 1914 7788 4097 15730 27423 ...
#>  $ LRPP       : num  9300 5051 13317 10524 3285 ...
#>  $ SRPP       : num  2918 3859 1195 980 4115 ...
#>  $ SLRPP      : num  12219 8910 14512 11504 7400 ...
#>  $ LR         : num  4213000 18376000 1638000 2589000 36312000 ...
#>  $ SR         : num  1322000 14038000 147000 241000 45495000 ...
#>  $ SLR        : num  5535000 32414000 1785000 2830000 81807000 ...
#>  $ COLIn      : num  0.971 0.971 1.002 0.957 0.957 ...
#>  $ SRPP_cola  : num  3005 3974 1193 1024 4300 ...
#>  $ LRPP_cola  : num  9578 5202 13290 10997 3432 ...
#>  $ SLRPP_cola : num  12583 9176 14483 12021 7732 ...
#>  $ County     : chr  "Pinal County" "Pinal County" "La Paz County" "Yuma County" ...
#>  $ dType      : chr  "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" ...
#>  $ urb        : chr  "31-Town: Fringe" "23-Suburb: Small" "43-Rural: Remote" "42-Rural: Distant" ...
#>  $ op_shcls   : int  2 3 1 2 7 3 4 4 11 16 ...
#>  $ enroll_ccd : int  453 3638 123 246 11055 1914 7788 4097 15730 27423 ...
#>  $ dFRL       : int  355 2255 124 101 NA 1206 3121 NA NA 24918 ...
#>  $ dLEP       : int  9 54 7 NA 1399 12 53 66 602 1673 ...
#>  $ dIEP       : int  55 456 22 45 943 208 806 487 1872 3087 ...
#>  $ dWhite     : int  32 936 40 46 1380 1022 2750 1475 4362 1229 ...
#>  $ dBlack     : int  38 134 0 0 131 28 819 296 1366 2300 ...
#>  $ dHispanic  : int  370 2182 82 197 9316 752 3587 2154 8824 22336 ...
#>  $ dAsian_PI  : int  0 40 0 1 84 18 269 32 524 447 ...
#>  $ dHaw_PI    : int  0 8 0 1 25 2 34 14 36 47 ...
#>  $ dAmInd_AK  : int  11 289 0 1 86 28 68 42 386 660 ...
#>  $ d2races    : int  2 49 1 0 33 64 261 84 232 404 ...
#>  $ pctNW      : num  0.929 0.743 0.675 0.813 0.875 ...
#>  $ TPop       : int  20919 99300 10981 6760 200774 66620 136239 74245 364786 736331 ...
#>  $ StPop      : int  732 5472 305 351 11908 2720 8042 4444 20388 43744 ...
#>  $ StPov      : int  160 913 45 72 3123 580 868 559 4880 12330 ...
#>  $ StPovRate  : num  0.219 0.167 0.148 0.205 0.262 ...
#>  $ MPV        : int  108500 118400 65500 74600 118500 NA 245900 179800 159600 156900 ...
#>  $ MHI        : int  37806 44066 37661 43465 43243 NA 71737 59371 41995 41159 ...
#>  $ Region     : chr  "Southwest" "Southwest" "Southwest" "Southwest" ...
#>  $ sd_area    : num  718 1300 3809 3065 2454 ...
#>  $ st_per_sqmi: num  0.6306 2.7989 0.0323 0.0803 4.5045 ...
#>  $ year       : chr  "2017" "2017" "2017" "2017" ...
#>  $ geometry   :sfc_MULTIPOLYGON of length 13309; first list element: List of 1
#>   ..$ :List of 1
#>   .. ..$ : num [1:135, 1:2] -111 -111 -111 -111 -111 ...
#>   ..- attr(*, "class")= chr  "XY" "MULTIPOLYGON" "sfg"
#>  $ frl_rate   : num  0.784 0.62 1.008 0.411 NA ...
#>  - attr(*, "sf_column")= chr "geometry"
#>  - attr(*, "agr")= Factor w/ 3 levels "constant","aggregate",..: NA NA NA NA NA NA NA NA NA NA ...
#>   ..- attr(*, "names")= chr  "FIPS" "GEOID" "NAME" "sdType" ...
```

## Authors

  - Megan Brodzik (<megan@edbuild.org>), maintainer
  - Cecilia Depman (<cecilia@edbuild.org>), author
  - Sara Hodges (<sara@edbuild.org>), author
