% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_de.R
\name{calculate_de}
\alias{calculate_de}
\title{Calculate thermal quality of the habitat}
\usage{
calculate_de(te, tset_low, tset_up)
}
\arguments{
\item{te}{A vector containing operative temperatures.}

\item{tset_low}{Lower boundary of a species or population set-point range 
that was determined through thermal preference trials in a temperature 
gradient.}

\item{tset_up}{Upper boundary of the set-point range.}
}
\value{
Thermal quality of the habitat (de) and associated descriptive 
statistics.
}
\description{
This function calculates the thermal quality of the habitat (de) from the
perspective of the focal species or population as described by Hertz et al. 
(1993). Descriptive statistics are automatically computed as well.
}
\examples{
te <- na.omit(bufbuf[,"te"])
de_stats <- calculate_de(te, 19.35, 26.44)

}
\references{
Hertz, P. E., Huey, R. B., & Stevenson, R. D. (1993). Evaluating temperature 
regulation by field-active ectotherms: the fallacy of the inappropriate 
question. The American Naturalist, 142(5), 796-818.
}
