% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{ec_networks}
\alias{ec_networks}
\title{Networks}
\usage{
ec_networks(pc, pp, cutoff_c = 0.2, cutoff_p = 0.4, tbl = FALSE,
  compute = "both")
}
\arguments{
\item{pc}{matrix or tibble/data.frame, if d is a tibble/
data.frame it must contain the columns from (character/factor), to
(character/factor) and value (numeric), if it is a matrix it must be a
numeric matrix with countries in row names and column names}

\item{pp}{matrix or tibble/data.frame, if d is a
tibble/data.frame it must contain the columns from (character/factor), to
(character/factor) and value (numeric), if it is a matrix it must be a
numeric matrix with products in row names and column names}

\item{cutoff_c}{all the values below the specified
cutoff_c will be converted to 0 and excluded from the countries
network (default set to 0.2)}

\item{cutoff_p}{all the values below the specified
cutoff_p will be converted to 0 and excluded from the products network
(default set to 0.4)}

\item{tbl}{when set to TRUE the output will be a tibble instead of a
graph (default set to FALSE)}

\item{compute}{by default set to "both", it can also be "country" or
"product"}
}
\description{
Networks
}
\examples{
ec_networks(
  pc = ec_output_demo$proximity_tbl$proximity_c,
  pp = ec_output_demo$proximity_tbl$proximity_p,
  tbl = TRUE
)

}
\references{
For more information on networks such as the product space and its
applications see:

\insertRef{atlas2014}{economiccomplexity}
}
\keyword{functions}
