% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productivity_levels.R
\name{productivity_levels}
\alias{productivity_levels}
\title{Productivity Levels}
\usage{
productivity_levels(trade_data = NULL, country1 = "country",
  product1 = "product", value1 = "value", gdp_data = NULL,
  country2 = "country", value2 = "value", tbl_output = FALSE)
}
\arguments{
\item{trade_data}{matrix or tibble/data.frame (e.g. \code{world_trade_2017}). If the input is a matrix it
must be a zero/one matrix with countries in rows and products in columns.
If the input is a tibble/data.frame it must contain at least three columns with countries, products and
values.}

\item{country1}{string to indicate the column that contains exporting countries in revealed_comparative_advantage
(set to "country" by default)}

\item{product1}{string to indicate the column that contains exported products in revealed_comparative_advantage
(set to "product" by default)}

\item{value1}{string to indicate the column that contains traded values in revealed_comparative_advantage
(set to "value" by default)}

\item{gdp_data}{vector or tibble/data.frame (e.g. \code{world_gdp_and_population_2017}).
If the input is a vector it must be a numeric vector with optional names.
If the input is a tibble/data.frame it must contain at least two columns with countries and values.}

\item{country2}{string to indicate the column that contains exporting countries in revealed_comparative_advantage
(set to "country" by default)}

\item{value2}{string to indicate the column that contains traded values in revealed_comparative_advantage
(set to "value" by default)}

\item{tbl_output}{when set to TRUE the output will be a tibble instead of a matrix (default set to FALSE)}
}
\description{
Productivity Levels
}
\examples{
productivity_levels(
 trade_data = services_trade_2016$services_trade_2016_matrix,
 country1 = "country",
 product1 = "product",
 value1 = "value",
 gdp_data = gdp_pc_2016$gdp_pc_2016_numeric,
 country2 = "country",
 value2 = "value",
 tbl_output = TRUE
)
}
\references{
For more information on prody and its applications see:

\insertRef{atlas2014}{economiccomplexity}

\insertRef{exportmatters2005}{economiccomplexity}
}
\keyword{functions}
