% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_transfer.R
\name{wf_transfer}
\alias{wf_transfer}
\title{ECMWF data transfer function}
\usage{
wf_transfer(
  url,
  user = "ecmwfr",
  path = tempdir(),
  filename = tempfile("ecmwfr_", tmpdir = ""),
  verbose = TRUE
)
}
\arguments{
\item{url}{R6 \code{\link[ecmwfr]{wf_request}}) query output or API endpoint}

\item{user}{user (email address) used to sign up for the ECMWF data service,
used to retrieve the token set by \code{\link[ecmwfr]{wf_set_key}}.}

\item{path}{path were to store the downloaded data}

\item{filename}{filename to use for the downloaded data}

\item{verbose}{show feedback on data transfers}
}
\value{
a (netCDF) file of data on disk as specified by a
\code{\link[ecmwfr]{wf_request}}
}
\description{
Returns the contents of the requested url as a (NetCDF) file downloaded
to disk or the current status of the requested transfer.
}
\details{
Normal workflows would use the methods included in returned objects. This is
for legacy support and custom scripting only.
}
\examples{

\dontrun{
# request data and grab url and try a transfer
# (request not provided)
r <- wf_request(request, transfer = FALSE)

# check transfer, will download if available
wf_transfer(r$get_url())
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_request}}
}
\author{
Koen Hufkens
}
