% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.band}
\alias{ecr.band}
\title{Area band}
\usage{
ecr.band(df = NULL, lower = NULL, upper = NULL, two = FALSE, ...)
}
\arguments{
\item{df}{A data.frame with lower and upper numerical columns.}

\item{lower}{The column name of band's lower boundary, a string.}

\item{upper}{The column name of band's upper boundary, a string.}

\item{two}{Type of rendering - by polygon (FALSE,default), or by two stacked lines (TRUE)}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-line.type}{serie}}
}
\value{
One list serie when two=FALSE, or a list of two list series when two=TRUE
}
\description{
A 'custom' serie with lower and upper boundaries
}
\details{
When two=FALSE, the coordinates of the two boundaries are chained into a polygon and displayed as one. Uses absolute cartesian coordinates. \cr
When two=TRUE, two smooth \emph{stacked} lines are drawn, one with customizable areaStyle. The upper boundary coordinates represent values on top of the lower boundary coordinates.
}
\examples{
myList <- list(x=LETTERS[1:7],
               d=c(140, 232, 101, 264, 90, 340, 250),
               u=c(120, 282, 111, 234, 220, 340, 310),
               l=c(200, 332, 151, 400, 190, 540, 450))
data <- as.data.frame(do.call(cbind, myList))
colnames(data) <- c('x','down','up','coord')
p <- ec.init(load='custom')
p$x$opts <- list(
  xAxis=list(list(type='category', boundaryGap=FALSE, data=data$x)),
  yAxis=list(list(scale=TRUE)),
  legend=list(ey=''),
  series = ecr.band(data, 'down', 'up', two=TRUE, name='band')   # two=TRUE
  #series = list(ecr.band(data, 'down', 'up', name='polyBand'))  # two=FALSE
)
p$x$opts$series <- append(p$x$opts$series, 
  list(list(name='line',type='line', lineStyle=list(width=2), data=data$coord)) )
p

}
