% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_modularity}
\alias{e_modularity}
\title{Modularity}
\usage{
e_modularity(e, modularity = TRUE)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{modularity}{Either set to \code{TRUE}, or a \code{list}.}
}
\description{
Graph modularity extension will do community detection and partian a graph's vertices in several subsets.
Each subset will be assigned a different color.
}
\note{
Does not work in RStudio viewer, open in browser.
}
\section{Modularity}{

\itemize{
  \item{\code{resolution} Resolution}
  \item{\code{sort} Whether to sort to comunities}
}
}

\examples{
nodes <- data.frame(
  name = paste0(LETTERS, 1:100),
  value = rnorm(100, 10, 2),
  stringsAsFactors = FALSE
)

edges <- data.frame(
  source = sample(nodes$name, 200, replace = TRUE),
  target = sample(nodes$name, 200, replace = TRUE),
  stringsAsFactors = FALSE
)

e_charts() \%>\%
  e_graph() \%>\%
  e_graph_nodes(nodes, name, value) \%>\%
  e_graph_edges(edges, source, target) \%>\%
  e_modularity(
    list(
      resolution = 5,
      sort = TRUE
    )
  )
}
\seealso{
\href{https://github.com/ecomfe/echarts-graph-modularity}{Official documentation}
}
