% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_properties.R
\docType{class}
\name{EBV netCDF properties-class}
\alias{EBV netCDF properties-class}
\title{EBV netCDF properties class (S4)}
\value{
S4 class containing the EBV netCDF properties
}
\description{
EBV netCDF properties class (S4)
}
\section{Slots}{

\describe{
\item{\code{general}}{Named list. Elements: title, description, doi, ebv_class,
ebv_name, ebv_domain, references, source, project_name, project_url,
creator_name, creator_institution, creator_email, contributor_name,
publisher_name, publisher_institution, publisher_email, comment, keywords,
id, history, licence, conventions, naming_authority, date_created,
date_issued, entity_names, entity_type, entity_scope,
entity_classification_name, entity_classification_url, taxonomy,
taxonomy_lsid}

\item{\code{spatial}}{Named list. Elements: wkt2, epsg, extent, resolution,
crs_units, dimensions, scope, description}

\item{\code{temporal}}{Named list. Elements: resolution, units, timesteps, dates}

\item{\code{metric}}{Named list. Elements: name, description, units}

\item{\code{scenario}}{Named list. Elements: name, description}

\item{\code{ebv_cube}}{Named list. Elements: units, coverage_content_type, fillvalue,
type}
}}

\note{
If the properties class holds e.g. no scenario information this is
indicated with an element called status in the list. \cr If you read an EBV
netCDF based on an older standard, the properties will differ from the
definition above. If the dataset does not encompass taxonomic info, the
'taxonomy' is NA. Besides, even if a dataset encompasses the taxonomy
information, the 'taxonomy_lsid' can be NA.
}
