% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-extent.R
\name{project_extent}
\alias{project_extent}
\title{Transform a spatiotemporal extent to a different CRS}
\usage{
project_extent(x, crs)
}
\arguments{
\item{x}{\link{ebirdst_extent} object; a spatiotemporal extent.}

\item{crs}{coordinate references system, given either as a proj4string, an
integer EPSG code, or a \code{crs} object generated with \code{\link[=st_crs]{st_crs()}}.}
}
\value{
An \link{ebirdst_extent} object in the new CRS.
}
\description{
Transform an eBird Status and Trends extent object to a different
coordinate reference system. This is most commonly required to transform the
extent to the sinusoidal CRS used by the eBird Status and Trends rasters.
}
\examples{
# construct an ebirdst_extent object
bb_vec <- c(xmin = -80, xmax = -70, ymin = 40, ymax = 47)
bb <- sf::st_bbox(bb_vec, crs = 4326)
bb_ext <- ebirdst_extent(bb)

# transform to sinusoidal projection of rasters
sinu <- "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6371007 +b=6371007 +units=m +no_defs"
project_extent(bb_ext, crs = sinu)

# also works on polygon extents
poly <- sf::read_sf(system.file("shape/nc.shp", package="sf"))
poly_ext <- ebirdst_extent(poly)
project_extent(poly_ext, crs = sinu)
}
