% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-ppms.R
\name{plot_all_ppms}
\alias{plot_all_ppms}
\title{Plot all predictive performance metrics}
\usage{
plot_all_ppms(path, ext)
}
\arguments{
\item{path}{character; full path to directory containing the eBird Status and
Trends products for a single species.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent to filter the
data to.}
}
\value{
Plot of metric box plots by category
}
\description{
For a spatiotemporal extent, plots bar plots for all available predictive
performance metrics within three categories: Binary Occurrence, Occurrence
Probability, and Abundance.
}
\examples{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# define a spatiotemporal extent to plot data from
bb_vec <- c(xmin = -83, xmax = -82, ymin = 41, ymax = 48)
e <- ebirdst_extent(bb_vec, t = c("04-01", "06-30"))
\donttest{
# plot ppms within extent
plot_all_ppms(path = sp_path, ext = e)
}
}
