% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insertVariable.R
\name{insertVariable}
\alias{insertVariable}
\title{Reorder a single variable in a \code{GADSdat}.}
\usage{
insertVariable(GADSdat, var, varBefore)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{var}{Character string of the variable name which should be sorted.}

\item{varBefore}{Character string of the variable name which should be followed by \code{var}.}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Reorder a single variables in a \code{GADSdat}. The variable (\code{var}) can be inserted right after another variable (\code{varBefore}).
}
\details{
The variables in the \code{dat} and in the \code{labels} section are ordered. For reordering the whole \code{GADSdat}, see
\code{\link{orderLike}}.
}
\examples{
pisa2 <- insertVariable(pisa, var = "migration", varBefore = "idclass")

}
