% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stemInclusionTuples.R
\name{stemInclusionTuples}
\alias{stemInclusionTuples}
\title{Create item inclusion tuples from item stem.}
\usage{
stemInclusionTuples(items, idCol = "ID", stemCol)
}
\arguments{
\item{items}{A \code{data.frame} with information on an item pool.}

\item{idCol}{character or integer indicating the item ID column in \code{items}.}

\item{stemCol}{A column in \code{items} containing the item stems or stimulus names, shared among items which should be in the same test form.}
}
\value{
A \code{data.frame} with two columns.
}
\description{
If item-stimulus hierarchies are stored in a single stimulus column,
\code{stemInclusionTuples} transforms this format into item pairs ('tuples').
}
\details{
Inclusion tuples can be used by \code{\link{itemInclusionConstraint}} to set up inclusion constraints.
}
\examples{
# Example data.frame
inclDF <- data.frame(ID = paste0("item_", 1:6),
          stem = c(rep("stim_1", 3), "stim_3", "stim_4", "stim_3"),
          stringsAsFactors = FALSE)

# Create tuples
stemInclusionTuples(inclDF, idCol = "ID", stemCol = "stem")


}
