% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyVolcano.R
\name{easyMAplot}
\alias{easyMAplot}
\title{Interactive MA plot labels}
\usage{
easyMAplot(
  data,
  x = NULL,
  y = NULL,
  padj = NULL,
  fdrcutoff = 0.05,
  colScheme = c("darkgrey", "blue", "red"),
  hline = 0,
  labelDir = "yellipse",
  xlab = expression("log"[2] ~ " mean expression"),
  ylab = expression("log"[2] ~ " fold change"),
  filename = NULL,
  showCounts = TRUE,
  useQ = FALSE,
  ...
)
}
\arguments{
\item{data}{The dataset for the plot. Automatically attempts to recognises
DESeq2 and limma objects.}

\item{x}{Name of the column containing mean expression. For DESeq2 and limma
objects this is automatically set.}

\item{y}{Name of the column containing log fold change. For DESeq2 and limma
objects this is automatically set.}

\item{padj}{Name of the column containing adjusted p values. For DESeq2 and
limma objects this is automatically set.}

\item{fdrcutoff}{Cut-off for FDR significance. Defaults to FDR < 0.05. Can
be vector with multiple cut-offs.}

\item{colScheme}{Colour colScheme. Length must match either length(fdrcutoff) + 1
to allow for non-significant genes, or match length(fdrcutoff) * 2 + 1 to
accommodates asymmetric colour colSchemes for positive & negative fold change.
(see examples).}

\item{hline}{Vector of horizontal lines (default is y = 0).}

\item{labelDir}{Option for label lines. See \code{\link[=easylabel]{easylabel()}}.}

\item{xlab}{x axis title. Accepts expressions.}

\item{ylab}{y axis title. Accepts expressions.}

\item{filename}{Filename for saving to pdf.}

\item{showCounts}{Logical whether to show legend with number of
differentially expressed genes.}

\item{useQ}{Logical whether to convert nominal P values to q values.
Requires the qvalue Bioconductor package.}

\item{...}{Other arguments passed to \code{\link[=easylabel]{easylabel()}}.}
}
\value{
No return value
}
\description{
Interactive labelling of MA plots using shiny/plotly interface.
}
\seealso{
\code{\link[=easylabel]{easylabel()}} \code{\link[=easyVolcano]{easyVolcano()}}
}
