% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsRoca.R
\name{EnsRoca}
\alias{EnsRoca}
\alias{EnsRocss}
\alias{oldEnsRoca}
\title{Area Under the ROC Curve}
\usage{
EnsRoca(ens, obs, use.easy = FALSE)

EnsRocss(ens, obs, use.easy = FALSE)
}
\arguments{
\item{ens}{n x j matrix of n probability forecasts for j categories}

\item{obs}{n x j matrix of occurence of n verifying observations in j categories}

\item{use.easy}{logical, should implementation of standard errors as implemented
in \code{easyVerifcation} be used (see below)?}
}
\description{
Computes the area under the ROC curve given the observations. 
  \code{EnsRoca} computes the Area Under the Curve (AUC). For ease of interpretation,
  \code{EnsRocss} converts the AUC to the range from -1 to 1 with zero indicating
  a forecast with no discrimination.
}
\section{Standard Error}{
 
  
  If used with \code{SpecsVerification >= 0.5}, the standard errors as implemented
  in the function \code{SpecsVerification::Auc} are used. 
  
  If \code{use.easy = TRUE} or when used with an older version of \code{SpecsVerification}, 
  the standard error \eqn{\sigma} of the ROC area 
  skill score is given by the following formula after Broecker (2012).
  
  \deqn{\sigma^2 = \frac{1}{3} \left(\frac{1}{N_0} + \frac{1}{N_1} + 
  \frac{1}{N_0 N_1} \right)}{\sigma^2 = 1/3 (1/N0 + 1/N1 + 1/(N0 N1))}
  
  Where \eqn{\sigma} is the standard error, \eqn{N_1}{N1} the number of 
  events, and \eqn{N_0}{N0} the number of non-events in category \code{i}.
}
\examples{
tm <- toymodel()

## compute ROC area for tercile forecasts using veriApply
veriApply("EnsRoca", fcst=tm$fcst, obs=tm$obs, prob=1:2/3)

}
\references{
Br\"ocker, J. (2012). Probability forecasts. Forecast 
  Verification: A Practitioner's Guide in Atmospheric Science, Second 
  Edition, 119-139.
}
\seealso{
\code{\link{veriApply}}, \code{\link{EnsRocss}}
}

