% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf-package.R
\docType{package}
\name{eaf-package}
\alias{eaf-package}
\alias{_PACKAGE}
\alias{eaf}
\title{Computation and visualization of the empirical attainment function (EAF) for
the analysis of random sets in multi-criterion optimization.}
\description{
The empirical attainment function (EAF) describes the probabilistic
distribution of the outcomes obtained by a stochastic algorithm in the
objective space. This package implements plots of summary
attainment surfaces and differences between the first-order
EAFs. These plots may be used for exploring the performance of
stochastic local search algorithms for biobjective optimization
problems and help in identifying certain algorithmic behaviors in a
graphical way.
}
\section{Functions}{


\tabular{rl}{
\code{\link[=eafdiffplot]{eafdiffplot()}} \tab  Empirical attainment function differences\cr
\code{\link[=eafplot]{eafplot()}} \tab  Plot the Empirical Attainment Function for two objectives\cr
\code{\link[=read_datasets]{read_datasets()}} \tab  Read several data.frame sets
}
}

\section{Data}{


\describe{
\item{\code{\link{gcp2x2}}}{  Metaheuristics for solving the Graph Vertex Coloring Problem}
\item{\code{\link{HybridGA}}}{  Results of Hybrid GA on vanzyl and Richmond
water networks}
\item{\code{\link{SPEA2minstoptimeRichmond}}}{ Results of SPEA2 when minimising electrical cost and maximising the
minimum idle time of pumps on Richmond water network}
}

Extras are available at \code{system.file(package="eaf")}:

\tabular{rl}{
\code{extdata}        \tab  External data sets (see \code{\link{read_datasets}}) \cr
\code{scripts/eaf}    \tab  EAF command-line program \cr
\code{scripts/eafplot}\tab  Perl script to generate plots of attainment surfaces\cr
\code{scripts/eafdiff}\tab  Perl script to generate plots of EAF differences
}
}

\examples{
data(gcp2x2)
tabucol<-subset(gcp2x2, alg!="TSinN1")
tabucol$alg<-tabucol$alg[drop=TRUE]
eafplot(time+best~run,data=tabucol,subset=tabucol$inst=="DSJC500.5")

eafplot(time+best~run|inst,groups=alg,data=gcp2x2)
eafplot(time+best~run|inst,groups=alg,data=gcp2x2,
percentiles = c(0,50,100), cex = 1.4, lty = c(2,1,2),lwd = c(2,2,2),
       col = c("black","blue","grey50"))
extdata_path <- system.file(package="eaf","extdata")
A1 <- read_datasets(file.path(extdata_path,"ALG_1_dat.xz"))
A2 <- read_datasets(file.path(extdata_path,"ALG_2_dat.xz"))
eafplot(A1, percentiles=c(50))
eafplot(list(A1=A1, A2=A2), percentiles=c(50))
eafdiffplot(A1, A2)
## Save to a PDF file
# dev.copy2pdf(file="eaf.pdf", onefile=TRUE, width=5, height=4)
}
\references{
\insertRef{Grunert01}{eaf}

\insertRef{GruFon2009:emaa}{eaf}

\insertRef{LopPaqStu09emaa}{eaf}
}
\seealso{
Useful links:
\itemize{
  \item \url{http://lopez-ibanez.eu/eaftools}
  \item \url{https://github.com/MLopez-Ibanez/eaf}
  \item Report bugs at \url{https://github.com/MLopez-Ibanez/eaf/issues}
}

}
\author{
Maintainer:  Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
\email{manuel.lopez-ibanez@manchester.ac.uk}

Contributors: Carlos Fonseca, Luis Paquete, Thomas \enc{Stützle}{Stuetzle},
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}, Marco Chiarandini and
\enc{Mickaël}{Mickael} Binois.
}
\concept{empirical attainment function}
\concept{multivariate}
\concept{optimize}
\concept{time-quality algorithm profile}
\keyword{graphs}
\keyword{package}
