% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext.R
\name{NelsonAalen}
\alias{NelsonAalen}
\title{Cox-Oakes extension of the Nelson-Aalen estimates for a Cox model}
\usage{
NelsonAalen(b, Xold, Xnew, events, time, tpred = 0:round(max(time, na.rm
  = T), 0), plot = FALSE)
}
\arguments{
\item{b}{Beta coefficients at optimal glmnet coxnet model (lambda, alpha)}

\item{Xold}{Data matrix with rows as individuals (i.e. training data)}

\item{Xnew}{Possible new prediction data matrix (if omitted the training data is used, or if it is a new dataset the columns should comform to the training data and new individuals be provided as rows)}

\item{events}{Deaths or right-censoring per each individual (1 death 0 alive censored) for Xold}

\item{time}{Times to event or censoring for Xold}

\item{tpred}{The predicted time points; more tight grid gives a smoother curve}

\item{plot}{Should an individualized plot be plotted to show how the cumulative survival curves behave}
}
\value{
Predicted times-to-event predictions either for the training data or an optional provided novel dataset
}
\description{
Implementing the heuristic Cox and Oakes extension of the Nelson-Aalen estimate for Cox model to extract individual-specific survival. Time-to-event predictions are then given at the first time point at which an individual reaches an event probability of 50%.
}
\note{
See section 3.6 at http://data.princeton.edu/pop509/NonParametricSurvival.pdf for the reference
}
\examples{
data(TYKSSIMU)
library(survival)
xdat <- as.matrix(xMEDISIMU)
ydat <- yMEDISIMU[,"surv"]
}
\author{
Teemu Daniel Laajala \email{teelaa@utu.fi}
}
