% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_end_state_probabilities.R
\name{add_end_state_probabilities}
\alias{add_end_state_probabilities}
\title{Constructs a multifurcating trajectory using end state probabilities}
\usage{
add_end_state_probabilities(
  dataset,
  end_state_probabilities,
  pseudotime = NULL,
  do_scale_minmax = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{end_state_probabilities}{A dataframe containing the \emph{cell_id} and additional numeric columns containing the probability for every end milestone. If the tibble contains only a cell_id column, the data will be processed using \code{add_linear_trajectory}}

\item{pseudotime}{A named vector of pseudo times.}

\item{do_scale_minmax}{Whether or not to scale the pseudotime between 0 and 1.
Otherwise, will assume the values are already within that range.}

\item{...}{Extras to be added to the trajectory}
}
\value{
A trajectory object
}
\description{
Constructs a multifurcating trajectory using the pseudotime values of each cell and their end state probabilities.
If pseudotime values are not given, will use pseudotime already present in the dataset.
}
\examples{
dataset <- wrap_data(cell_ids = letters)

pseudotime <- runif(length(dataset$cell_ids))
names(pseudotime) <- dataset$cell_ids
pseudotime
end_state_probabilities <- tibble::tibble(
  cell_id = dataset$cell_ids,
  A = runif(length(dataset$cell_ids)),
  B = 1-A
)
end_state_probabilities
trajectory <- add_end_state_probabilities(dataset, end_state_probabilities, pseudotime)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
