# README #

This README file documents the steps necessary to get `dynr` cooking.  That was the first of many food-based puns.  It will not be the last.

[![](http://cranlogs.r-pkg.org/badges/dynr)](https://cran.r-project.org/package=dynr)

### Who is this repository for? ###

This repository is primarily for developers. If you're not currently on the development team but would like to be, please contact Sy-Miin Chow at Pennsylvania State University.  You will need

* Good computer programming skills (R and C preferably)
* Decent mathematical ability
* Knowledge of or interest in dynamical systems
* Some exposure to statistical methods

If you're not a developer and just want to install `dynr` to run your models, please see the CRAN page including the vignette with installation guidelines.

### How do I get set up? ###

Windows People

* Summary of set up
* Configuration
* Dependencies
* Database configuration
* How to run tests
* Deployment instructions

Mac People

* Summary of set up
* Configuration
* Dependencies
* Database configuration
* How to run tests
* Deployment instructions

### Contribution guidelines ###

* Writing tests
* Code review
* Other guidelines

We primarily use a [centralized workflow](https://www.atlassian.com/git/tutorials/comparing-workflows#centralized-workflow) in git.  Occasionally, we employ a [feature branch](https://www.atlassian.com/git/tutorials/comparing-workflows#feature-branch-workflow) style for larger features that may break the master branch for extended periods of time.

Please follow [these basic guidelines](https://chris.beams.io/posts/git-commit/) when writing commit messages.

 1. Separate subject from body with a blank line
 1. Limit the subject line to 50 characters
 1. Capitalize the subject line
 1. Do not end the subject line with a period
 1. **Use the imperative mood in the subject line**
 1. Wrap the body at 72 characters
 1. Use the body to explain *what* and *why*, not *how*

We use [win-builder](https://win-builder.r-project.org/) to help test the repository prior to [submitting a new release to CRAN](https://cran.r-project.org/submit.html).

A Note to developers: there is a bug in `roxygen2` such that the latest version will not build our documentation.  It is a [known issue](https://github.com/r-lib/roxygen2/issues/595) that will be resolved soon.  In the meantime, use an older version of the package.  Install it with `devtools::install_version(package = 'roxygen2',version = '5.0.1', repos = c(CRAN = "https://cran.rstudio.com"))`

### Who do I talk to? ###

* Michael D. Hunter is the Repo owner and admin
* Sy-Miin Chow is the principle investigator on the grant that funds dynr
* Other members of the development team include but are not limited to Lu Ou, Meng Chen, Linying Ji, Hui-Ju Hung, and Yanling Li

Contact the Repo owner to obtain write permission to this repository.
