\name{pew}
\alias{pew}
\alias{pewcox}
\title{Calculate dynamic prediction error curve}
\description{
Calculate dynamic fixed width prediction error curve.
}
\usage{
pew(time, status, tsurv, survmat, tcens, censmat,
    width, FUN = c("KL", "Brier"), tout)
pewcox(formula, censformula, width, data, censdata,
    FUN = c("KL", "Brier"), tout, CV = FALSE, progress = FALSE)
}
\arguments{
  \item{time}{Vector of time points in data}
  \item{status}{Vector of event indicators in data}
  \item{tsurv}{Vector of time points corresponding to the estimated survival probabilities in \code{survmat}}
  \item{survmat}{Matrix of estimated survival probabilities; dimension should be
  length of tsurv x length of time}
  \item{tcens}{Vector of time points corresponding to the estimated censoring probabilities in \code{censmat}}
  \item{censmat}{Matrix of estimated censoring probabilities; dimension should be
  length of tcens x length of time}
  \item{width}{Width of the window}
  \item{FUN}{The error function, either \code{"KL"} (default) for Kullback-Leibler or \code{"Brier"} for Brier score}
  \item{tout}{Vector of time points at which to evaluate prediction error. If
  missing, prediction error will be evaluated at all time points where the estimate
  will change value}
  \item{formula}{Formula for prediction model to be used as in \code{\link[survival:coxph]{coxph}}}
  \item{censformula}{Formula for censoring model, also to be used as in \code{\link[survival:coxph]{coxph}}}
  \item{data}{Data set in which to interpret \code{formula}}
  \item{censdata}{Data set in which to interpret \code{censformula}}
  \item{CV}{Boolean (default=\code{FALSE}); if \code{TRUE}, (leave-one-out)
  cross-validation is used for the survival probabilities}
  \item{progress}{Boolean (default=\code{FALSE}); if \code{TRUE}, progress is printed on screen}
}
\details{
Corresponds to Equation (3.6) in van Houwelingen and Putter (2011). The
\code{censformula} is used to calculate inverse probability of censoring
weights (IPCW).}
\value{
A data frame with columns
  \item{time}{Event time points}
  \item{Err}{Prediction error of model specified by \code{formula} at these time points}
and with attribute \code{"width"} given as input.
}
\references{
van Houwelingen HC, Putter H (2011). Dynamic Prediction in Clinical Survival Analysis.
Chapman & Hall.
}
\author{Hein Putter \email{H.Putter@lumc.nl}}
\examples{
data(ova)
pewcox(Surv(tyears, d) ~ Karn + Broders + FIGO + Ascites + Diam, Surv(tyears, 1-d) ~ 1,
  width=2, data = ova, FUN="Brier", tout=seq(0,6,by=0.5))
pewcox(Surv(tyears, d) ~ Karn + Broders + FIGO + Ascites + Diam, Surv(tyears, 1-d) ~ 1,
  width=2, data = ova, FUN="Brier", tout=seq(0,6,by=0.5), CV=TRUE, progress=TRUE)
}
\keyword{univar}
