% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_topology.R
\name{plot_topology}
\alias{plot_topology}
\title{Plot the topology of a trajectory}
\usage{
plot_topology(
  trajectory,
  color_milestones = c("auto", "given", "cubeHelix", "Set3", "rainbow"),
  milestones = NULL,
  layout = NULL,
  arrow = grid::arrow(type = "closed", length = unit(0.4, "cm"))
)
}
\arguments{
\item{trajectory}{A dynwrap trajectory.}

\item{color_milestones}{Which palette to use for colouring the milestones
\itemize{
\item \code{auto}: Determine colours automatically. If \code{color} is already specified in
milestones tibble, this will be used. Otherwise, the colour scheme is determined by
\code{milestone_palette_list$auto}.
\item \code{given}: The \code{milestones} object already contains a column \code{color}.
\item \code{cubeHelix}: Use the \code{rje::cubeHelix()} palette.
\item \code{Set3}: Use the \code{RColorBrewer::brewer.pal(name = "Set3")} palette.
\item \code{rainbow}: Use the \code{grDevices::rainbow()} palette.
}}

\item{milestones}{Tibble containing the column \code{milestone_id} (character).
If \code{color_milestones} is set to \code{"given"}, this tibble should also contain a column
\code{color} (character), containing colour hex codes (e.g. \code{"#123456"}).}

\item{layout}{The type of layout to create. See \code{\link[ggraph:ggraph]{ggraph::ggraph()}} for more info.}

\item{arrow}{The type and size of arrow in case of directed trajectories. Set to NULL to remove arrow altogether.}
}
\value{
A topology ggplot of a trajectory.
}
\description{
Plot the topology of a trajectory
}
\examples{
data(example_disconnected)
plot_topology(example_disconnected)

data(example_tree)
plot_topology(example_tree)
}
\keyword{plot_trajectory}
