# Had issues with win builder. Thus, these lines
test_name <- "fixed_effects_like_recursive_least_squares"
cat("\nRunning", test_name, "\n")

if(interactive()){
  library(testthat); library(survival)

  if(grepl("testthat$", getwd()))
    source("../../R/test_utils.R") else
      source("./R/test_utils.R")
}



test_that("Works with EKF and logit model and that it work with one fixed and one non-fixed", {
          fit <- ddhazard(survival::Surv(start, stop, event) ~ ddFixed(group),
                          Q_0 = matrix(1), Q = matrix(.1),
                          data = head_neck_cancer,
                          by = 1,
                          control = list(fixed_terms_method = "E_step",
                                         save_risk_set = F, save_data = F))

          # plot(fit)
          # fit$fixed_effects

          # get_expect_equal(fit, file = "tmp.txt")

          expect_equal(c(fit$state_vecs),
                       c(-3.433679924186530, -3.434414048040867, -3.114287156755919, -2.782053525173589, -2.510930729466274, -2.122083757242843, -2.175409321118311, -2.516412833923826, -2.723582723248391, -2.864371716814146, -3.001004060351022, -3.194760615043944, -3.310327753213099, -3.365300219640627, -3.259345670496772, -3.303169375967643, -3.409970477434536, -3.501541168815749, -3.481592382506457, -3.559349423552475, -3.549082380633693, -3.662725980727870, -3.817681114456823, -3.925737344100360, -3.985805504969861, -4.105172876430405, -4.188500503575386, -4.236902139433206, -4.357905632176490, -4.455198946844585, -4.528631703948904, -4.578364620402361, -4.604506253664232, -4.607028261948091, -4.585758667118196, -4.540396914300307, -4.470533272124009, -4.375667125914672, -4.363530815624264, -4.434586557795067, -4.488525485257088, -4.524334065547548, -4.541699556818766, -4.543437100737172, -4.529475020434802, -4.499685844290741, -4.455040443521825, -4.397239273626069, -4.326037828250640, -4.245166771764445, -4.154369910409113, -4.053389638287614, -3.941968181653694, -3.926179927504561, -3.896034871508889, -3.851547073271464, -3.794756706956309, -3.725578499031569, -3.643902883962222, -3.549597815575200 ))

          expect_equal(c(fit$state_vars),
                       c(0.20954649115761625, 0.13742523801660356, 0.12776362434720762, 0.11460004590035977, 0.10061020013431873, 0.08957555787920109, 0.07538528439013892, 0.07710455357325803, 0.08762172775839716, 0.09768212004241301, 0.10629430389449669, 0.11515636902799065, 0.12700264486442819, 0.13767049444951657, 0.14657250276740741, 0.14702590952815880, 0.14979237469721232, 0.15742861871796365, 0.16778261594924057, 0.17472893801293135, 0.18291430862661828, 0.18675540087292891, 0.19481451785127085, 0.20724975299225715, 0.21992102176975756, 0.23034744527981668, 0.24377502364737655, 0.25641598093139284, 0.26662401892078791, 0.28069695282630391, 0.29644093159168150, 0.31266024914022339, 0.32856955037350843, 0.34354594811792738, 0.35700993771317346, 0.36836106135340474, 0.37693864215213219, 0.38199456280700167, 0.38213351716622618, 0.38312869383452752, 0.39414645444278096, 0.41192623623832847, 0.43507778614628223, 0.46024073964185813, 0.48756156155306862, 0.51730156485164358, 0.54883115567863761, 0.58105035340582800, 0.61442181329923451, 0.64636040962164110, 0.67723439573204902, 0.70734959389420859, 0.73696351908628621, 0.76629659855737298, 0.80721931948152237, 0.85944072911634239, 0.92085892375999800, 0.99225996838538788, 1.07465395887804971, 1.16925528963455649 ))

          expect_equal(c(fit$lag_one_cov),
                       c(0.12400565075048453, 0.09060644253579703, 0.08046058786272703, 0.06874744023704357, 0.05843647620670341, 0.04807648886209226, 0.04342823006931706, 0.04768242878265085, 0.05575000709415941, 0.06345688496908417, 0.07085972054588337, 0.07984334137531771, 0.08996836418036058, 0.09892406205862624, 0.10328519339287737, 0.10473852176182261, 0.10951529927043624, 0.11789221446697731, 0.12609019808230282, 0.13324450232606039, 0.13900060424798649, 0.14464939850082592, 0.15442538525099650, 0.16652662379702615, 0.17773775309844728, 0.18928370466383404, 0.20199189179921098, 0.21317521681003060, 0.22500822881876187, 0.23960254533946118, 0.25529734946804794, 0.27111200429101201, 0.28634436266228852, 0.30039263485454692, 0.31266561844604113, 0.32253161746980874, 0.32928545010404198, 0.33185789860815612, 0.33241004470018287, 0.33830408677338741, 0.35249324068786536, 0.37270642279330546, 0.39664409554970748, 0.42266969749819938, 0.45098518109429891, 0.48142126670783247, 0.51312569653061635, 0.54575435362485369, 0.57829173658389010, 0.60958468021061640, 0.63996828926087712, 0.66972252053356240, 0.69908479325619699, 0.73395440627381414, 0.78021944090475692, 0.83673329552832865, 0.90280466957766392, 0.97932928634140426, 1.06741628403776900 ))

          expect_equal(unname(c(fit$fixed_effects)),
                       c(0.4970703129092376  ))

          expect_equal(c(fit$n_iter),
                       c(7 ))

          expect_equal(c(fit$Q),
                       c(0.1102804882254061 ))

          expect_equal(c(fit$Q_0),
                       c(1e+00, 0e+00, 0e+00, 1e+05 ))

          expect_equal(c(fit$n_risk),
                       c(96, 95, 91, 84, 78, 65, 53, 49, 46, 43, 39, 37, 36, 36, 33, 31, 30, 30, 25, 25, 23, 21, 21, 21, 20, 19, 19, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 15, 14, 14, 14, 12, 12, 12, 11, 10, 10, 8, 8, 8, 8, 8, 7, 7, 6, 6, 6, 6, 6 ))

          expect_equal(c(fit$times),
                       c( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59 ))

          expect_equal(c(fit$risk_set),
                       c(NULL ))

          expect_equal(c(fit$data),
                       c(NULL ))

          expect_equal(c(fit$order),
                       c(1 ))

          expect_equal(c(fit$F_),
                       c(1, 0, 0, 1 ))

          expect_equal(c(fit$method),
                       c("EKF" ))

          expect_equal(c(fit$model),
                       c("logit" ))

          expect_equal(c(fit$est_Q_0),
                       c(FALSE ))

          expect_equal(c(fit$LR),
                       c(1 ))
})

test_that("Works with EKF and continous time model and that it work with one fixed and one non-fixed", {
  fit <- ddhazard(survival::Surv(start, stop, event) ~ ddFixed(group),
                  Q_0 = matrix(1), Q = matrix(.1),
                  data = head_neck_cancer, max_T = 35,
                  by = 1, model = "exp_bin",
                  control = list(fixed_terms_method = "E_step",
                                 save_risk_set = F, save_data = F))

  # matplot(fit$state_vecs)
  # fit$fixed_effects

  # get_expect_equal(fit)

  expect_equal(unname(c(fit$state_vecs)),
               c(-3.506009368713058, -3.506802217056613, -3.139097920076372, -2.785213584496826, -2.515653919853097, -2.068312492914208, -2.135763523261002, -2.523440860389107, -2.739944587674259, -2.875001647487119, -3.008234979627112, -3.221377892924538, -3.340990774806332, -3.388618612324266, -3.232012398223914, -3.274609054404784, -3.396456445314582, -3.498568278378368, -3.456181492895881, -3.540352189700419, -3.508743234300136, -3.637266132163683, -3.819447959891685, -3.944140789601589, -4.009203649582828, -4.153554697907790, -4.256537804324051, -4.319275995445820, -4.480839231751807, -4.621269093921450, -4.740227158357612, -4.838295411854773, -4.916107936967267, -4.974153526081268, -5.012745179446982, -5.032034212642930 ))

  expect_equal(unname(c(fit$state_vars)),
               c(0.23629629297036370, 0.14844724698303263, 0.13994518511871634, 0.12305158411646627, 0.10446998115364250, 0.09204954943972103, 0.07206340258679066, 0.07534620882248710, 0.09084261579595501, 0.10389698453521451, 0.11403835154875416, 0.12422684227354042, 0.13979305849264223, 0.15334515983150640, 0.16410778698814710, 0.16043446429494751, 0.16179499977235223, 0.17151036797119273, 0.18507745665365227, 0.19198504783404807, 0.20166303633109711, 0.20354814983007558, 0.21300179378647505, 0.22993835124417733, 0.24705208361304321, 0.26043325107332227, 0.27969394645036266, 0.29893212200366248, 0.31599925249417893, 0.34365922576255264, 0.37965686585773195, 0.42442295846409228, 0.47985797414526266, 0.54896793741458694, 0.63578735327424429, 0.74541861985877056 ))

  expect_equal(unname(c(fit$lag_one_cov)),
               c(NULL ))

  expect_equal(unname(c(fit$fixed_effects)),
               c(0.4240669044840085 ))

  expect_equal(unname(c(fit$n_iter)),
               c(13 ))

  expect_equal(unname(c(fit$Q)),
               c(0.1408004081342288 ))

  expect_equal(unname(c(fit$Q_0)),
               c(1e+00, 0e+00, 0e+00, 1e+05 ))

  expect_equal(unname(c(fit$n_risk)),
               c(96, 95, 91, 84, 78, 65, 53, 49, 46, 43, 39, 37, 36, 36, 33, 31, 30, 30, 25, 25, 23, 21, 21, 21, 20, 19, 19, 18, 18, 18, 18, 18, 18, 18, 18 ))

  expect_equal(unname(c(fit$times)),
               c( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 ))

  expect_equal(unname(c(fit$risk_set)),
               c(NULL ))

  expect_equal(unname(c(fit$data)),
               c(NULL ))

  expect_equal(unname(c(fit$order)),
               c(1 ))

  expect_equal(unname(c(fit$F_)),
               c(1, 0, 0, 1 ))

  expect_equal(unname(c(fit$method)),
               c("EKF" ))

  expect_equal(unname(c(fit$model)),
               c("exp_bin" ))

  expect_equal(unname(c(fit$est_Q_0)),
               c(FALSE ))

  expect_equal(unname(c(fit$LR)),
               c(1 ))
})

set.seed(849239)
sims_logit <- test_sim_func_logit(n_series = 4e2, n_vars = 3, x_range = 1, t_max = 10, x_mean = 0.5,
                                  beta_start = 1, intercept_start = -4)
# sum(sims_logit$res$event)
form <- formula(survival::Surv(tstart, tstop, event) ~ ddFixed(1) + ddFixed(x1) + x2 + x3)

test_that("Works with UKF and logit model", {
  # tmp <- file("tmp.txt")
  # sink(tmp)
  fit <- ddhazard(form, Q_0 = diag(1, 2), Q = diag(.1, 2),
                  data = sims_logit$res, id = sims_logit$res$id,
                  by = 1,
                  control = list(fixed_terms_method = "E_step",
                                 save_risk_set = F, save_data = F,
                                 method = "UKF",
                                 alpha = .01))

  # sink()
  # close(tmp)


  # matplot(sims_logit$betas, lty = 1, type = "l")
  # matplot(fit$state_vecs, lty = 2, type = "l", add = T, col = 3:4)
  # abline(h = fit$fixed_effects, col = 1:2, lty = 2)
  # get_expect_equal(fit)

  expect_equal(unname(c(fit$state_vecs)),
               c( 2.204142170144191, 2.201659467228804, 2.835854570733872, 2.395779062367009, 2.397812209810755, 2.225347797164639,  2.430074368451281, 3.032461717773980, 3.413040406593200, 3.454642508443022, 4.355820597298862, -4.486288791379789, -4.493655579644042, -2.766604104085253, -4.052323852178006, -4.088954993042360, -4.579158831378076, -4.010499883567714, -2.311835236547662, -1.228674926140861, -1.084463641518693, 1.480869330184758 ))

  expect_equal(unname(c(fit$state_vars)),
               c(0.2546575275467979, 0.1868525185214180, 0.1868525185214167, 0.7707635721923629, 0.2702800339857233, 0.3048486972795817, 0.3048486972795766, 1.2235564301783350, 0.2638285393303403, 0.3098788729213180, 0.3098788729213112, 1.2431752328177330, 0.1934410923465167, 0.1163195366414338, 0.1163195366414295, 0.6725913203885583, 0.2224471509609436, 0.2042424902347802, 0.2042424902347752, 0.9403879247670568, 0.2263457784500662, 0.2175801901985109, 0.2175801901985044, 1.0179240039417075, 0.2398081149781144, 0.2545309199181456, 0.2545309199181393, 1.1722318573639496, 0.2459163230232402, 0.2572659428747597, 0.2572659428747528, 1.2029812530863588, 0.2433049580666524, 0.1876145377722057, 0.1876145377721989, 0.9068642488159087, 0.2449741191033035, 0.1008654433536405, 0.1008654433536392, 0.4990786121351367, 0.2650249840923777, 0.1251477537309833, 0.1251477537309814, 0.5995914719579085 ))

  expect_equal(unname(c(fit$lag_one_cov)),
               c(NULL ))

  expect_equal(unname(c(fit$fixed_effects)),
               c(-2.978883486670685, 0.870630297963691 ))

  expect_equal(unname(c(fit$n_iter)),
               c(54 ))

  expect_equal(unname(c(fit$Q)),
               c(0.3361949438985762, 0.9169614297869177, 0.9169614297869177, 2.6438758103126032 ))

  expect_equal(unname(c(fit$Q_0)),
               c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1 ))

  expect_equal(unname(c(fit$n_risk)),
               c(400, 383, 346, 319, 293, 278, 261, 226, 161, 115 ))

  expect_equal(unname(c(fit$times)),
               c( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ))

  expect_equal(unname(c(fit$risk_set)),
               c(NULL ))

  expect_equal(unname(c(fit$data)),
               c(NULL ))

  expect_equal(unname(c(fit$order)),
               c(1 ))

  expect_equal(unname(c(fit$F_)),
               c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1 ))

  expect_equal(unname(c(fit$method)),
               c("UKF" ))

  expect_equal(unname(c(fit$model)),
               c("logit" ))

  expect_equal(unname(c(fit$est_Q_0)),
               c(FALSE ))

  expect_equal(unname(c(fit$LR)),
               c(1 ))
})

test_that("Works with second order random walk and logit model", {

  fit <- ddhazard(form, Q_0 = diag(c(rep(1, 2), rep(.1, 2))), Q = diag(.1, 2),
                  data = sims_logit$res, id = sims_logit$res$id,
                  by = 1, order = 2,
                  control = list(fixed_terms_method = "E_step",
                                 save_risk_set = F, save_data = F))

  # matplot(sims_logit$betas, lty = 1, type = "l")
  # matplot(fit$state_vecs[, 1:2], lty = 2, type = "l", add = T, col = 3:4)
  # abline(h = fit$fixed_effects, col = 1:2, lty = 2)
  # get_expect_equal(fit, file = "tmp.txt")

  expect_equal(unname(c(fit$state_vecs)),
               c( 0.3324749934791584, 1.0804006227204974, 2.1101369085374748,  2.2951607781263119, 2.0976175181681738, 1.7490466991929754,  2.0522614651567772, 2.2672343969759257, 2.7925922603660513,  2.7186559168285100, 3.7915265523881052, -2.7342144657035368, -2.4983774747822709, -1.9925465675936316, -2.1707303686249526, -2.5489031801896527, -2.8248122468171442, -2.2803014876954899, -1.6786057489438146, -0.6687625731196399, -0.2636440434353388,  1.1367642720944122, -0.2774142188958728, 0.3324749934791585,  1.0804006227204952, 2.1101369085374775, 2.2951607781263128,  2.0976175181681755, 1.7490466991929741, 2.0522614651567772,  2.2672343969759230, 2.7925922603660500, 2.7186559168285105, -2.8377981321002461, -2.7342144657035368, -2.4983774747822687, -1.9925465675936318, -2.1707303686249526, -2.5489031801896527, -2.8248122468171455, -2.2803014876954886, -1.6786057489438133, -0.6687625731196398, -0.2636440434353386 ))

  expect_equal(unname(c(fit$state_vars)),
               c( 0.144045081318171730, 0.062742170462260313, 0.043694903242608218, -0.009279880694438374, 0.062742170462260355, 0.146751521018913422, -0.012079237030204139, 0.048292652901546738, 0.043694903242608205, -0.012079237030204137, 0.093470467427786613, 0.003130267170580611, -0.009279880694438344, 0.048292652901546718, 0.003130267170580639,  0.093436408455602166, 0.108878681647664344, 0.014691135574856472,  0.070800266812753976, 0.004177204301459760, 0.014691135574856493,  0.118797232423143884, 0.002061436275646459, 0.081778309394155729,  0.070800266812753948, 0.002061436275646436, 0.144045081318165263,  0.062742170462260341, 0.004177204301459791, 0.081778309394155646,  0.062742170462260383, 0.146751521018910064, 0.093382947227573038, -0.015082918338695499, 0.071653744274809195, -0.015149584527088648, -0.015082918338695482, 0.081590140935209152, -0.013490002183850257,  0.068605236150284965, 0.071653744274809195, -0.013490002183850262,  0.108878681647661707, 0.014691135574855754, -0.015149584527088630,  0.068605236150284979, 0.014691135574855775, 0.118797232423147034,  0.097903614845856371, -0.019887042118252183, 0.076492438828081669, -0.018096779150443026, -0.019887042118252159, 0.079519019726791998, -0.022227122308731001, 0.058310420171585955, 0.076492438828081669, -0.022227122308731005, 0.093382947227573537, -0.015082918338695309, -0.018096779150443006, 0.058310420171585983, -0.015082918338695291,  0.081590140935209041, 0.109513908495323067, -0.017476850298143970,  0.081266594793556232, -0.019723257182417471, -0.017476850298143970,  0.109978909542938957, -0.029966773419754369, 0.067328442406815792,  0.081266594793556232, -0.029966773419754369, 0.097903614845856399, -0.019887042118252183, -0.019723257182417443, 0.067328442406815805, -0.019887042118252159, 0.079519019726792109, 0.116467250852115928, -0.015439331815838356, 0.084857591342620914, -0.024191899733130399, -0.015439331815838356, 0.150247271917070047, -0.035013612799438584,  0.095207132324561697, 0.084857591342620900, -0.035013612799438570,  0.109513908495323289, -0.017476850298144098, -0.024191899733130399,  0.095207132324561711, -0.017476850298144095, 0.109978909542938930,  0.136296621494219505, 0.002686006517692852, 0.090433142492514426, -0.025526402729928621, 0.002686006517692879, 0.186434650514230693, -0.028957637512523962, 0.126946374761916558, 0.090433142492514426, -0.028957637512523976, 0.116467250852115733, -0.015439331815838390, -0.025526402729928635, 0.126946374761916558, -0.015439331815838390,  0.150247271917070657, 0.107833379079613823, -0.028215276747781154,  0.086764450048672365, -0.040389047194000771, -0.028215276747781140,  0.133737062660611528, -0.024630667849881098, 0.118631943131627546,  0.086764450048672365, -0.024630667849881098, 0.136296621494219616,  0.002686006517693212, -0.040389047194000757, 0.118631943131627532,  0.002686006517693237, 0.186434650514231581, 0.106390409919765672, -0.023232850434839997, 0.080435889346733153, -0.039013782384841378, -0.023232850434839997, 0.121343293395130086, -0.027607285413364449,  0.094791253748182189, 0.080435889346733153, -0.027607285413364435,  0.107833379079613545, -0.028215276747780901, -0.039013782384841378,  0.094791253748182161, -0.028215276747780890, 0.133737062660611195,  0.138505648777803581, -0.033655559114539157, 0.088965071256875639, -0.044256257003823726, -0.033655559114539157, 0.119999795251596486, -0.018951051777148491, 0.085205347376192522, 0.088965071256875625, -0.018951051777148495, 0.106390409919765561, -0.023232850434840094, -0.044256257003823733, 0.085205347376192522, -0.023232850434840094,  0.121343293395130308, 0.207094585045795365, -0.100346384892573776,  0.124336942383001345, -0.066425588325376497, -0.100346384892573776,  0.221771419850055773, -0.064913275401391635, 0.119601962969311998,  0.124336942383001345, -0.064913275401391635, 0.138505648777803525, -0.033655559114539171, -0.066425588325376497, 0.119601962969311998, -0.033655559114539171, 0.119999795251596486 ))

  expect_equal(unname(c(fit$lag_one_cov)),
               c( 0.070792975976440714, 0.002070187670892547, 0.144040267143525635,  0.062748034553687340, 0.004185173589378911, 0.081764751808743763,  0.062748928951913696, 0.146741339449520392, 0.012949038749655039, -0.015095213549770350, 0.043698156172663268, -0.012083951825160338, -0.010733357362313286, 0.019464100307455184, -0.009283298585978974,  0.048297594430567067, 0.071630735484821642, -0.013464315993229493,  0.108857150960648269, 0.014719567504506620, -0.015130172646520860,  0.068577116041705910, 0.014714323785054301, 0.118759013663347790,  0.037637314338032503, -0.011962492484596104, 0.070792975976440464,  0.002070187670892280, -0.012928066409055047, 0.038453633812976562,  0.004185173589378900, 0.081764751808744471, 0.076483079792541292, -0.022220607878221426, 0.093341738157250498, -0.015033502896176647, -0.018105318152946512, 0.058317279621079243, -0.015044244754979846,  0.081537190896532080, 0.059879116608989515, -0.009034689939909857,  0.071630735484822045, -0.013464315993229448, -0.004664332356932328,  0.044245885474794591, -0.015130172646520675, 0.068577116041705785,  0.081369707456057830, -0.030147664262169947, 0.097893915092998190, -0.019880050186522252, -0.019879202353298559, 0.067580736343663003, -0.019894876501129841, 0.079525056215818332, 0.065277150093108666, -0.016428130662343096, 0.076483079792541236, -0.022220607878221457, -0.004541235588163158, 0.044027020986437931, -0.018105318152946512,  0.058317279621079285, 0.085213429249596545, -0.035647364133528793,  0.109635128494164333, -0.017688937251793730, -0.024712574792644895,  0.096274353552670375, -0.017694550927773577, 0.110334519667527720,  0.068531324734666887, -0.026099492341804611, 0.081369707456057871, -0.030147664262169985, -0.009504948536213989, 0.055162924342183152, -0.019879202353298570, 0.067580736343662948, 0.091221353805045646, -0.029922459711679714, 0.116785887325941390, -0.015972649029883774, -0.026638372475913871, 0.129022231924927816, -0.015981952454144431,  0.151311314312443795, 0.071141565044737121, -0.029947397265681339,  0.085213429249596434, -0.035647364133528807, -0.018229216072148148,  0.076819020995987142, -0.024712574792644840, 0.096274353552670527,  0.087394921897598773, -0.024992531085494825, 0.136741236786074943,  0.002570864810557495, -0.041184905757849014, 0.119379102847512006,  0.002177144345003199, 0.186828595451637325, 0.072206077821473563, -0.021948566612742460, 0.091221353805045674, -0.029922459711679811, -0.033260911990077587, 0.084404041110035355, -0.026638372475913771,  0.129022231924927705, 0.076360291295751781, -0.024950488922322364,  0.106320663484130912, -0.025145284189355594, -0.031976019437475064,  0.090427083550009585, -0.025685778946351837, 0.128511828466499223,  0.064161602815657026, -0.014008722949402287, 0.087394921897598690, -0.024992531085494769, -0.033419943330302661, 0.076435704744413885, -0.041184905757848951, 0.119379102847511867, 0.070939048401555391, -0.005578835897062914, 0.095772980536681845, -0.009097532823164136,  0.008001661385572095, 0.092410605567203874, -0.004862766932115348,  0.105515253817128646, 0.052815994396445784, -0.005240214617269768,  0.076360291295751878, -0.024950488922322461, -0.005832354468395085,  0.064699362196698154, -0.031976019437475037, 0.090427083550009710,  0.017079648051010830, -0.089942488658488515, 0.030736135950926766, -0.059161436404187327, -0.054233038213185633, 0.056090679976581369, -0.021650361466898072, 0.056312717258908698, 0.049823221210284714,  0.002734732499547872, 0.070939048401555418, -0.005578835897062914,  0.015924868604316848, 0.073656114802869252, 0.008001661385572130,  0.092410605567203805 ))

  expect_equal(unname(c(fit$fixed_effects)),
               c(-2.5845266972768153, 0.5967834928269278 ))

  expect_equal(unname(c(fit$n_iter)),
               c(56 ))

  expect_equal(unname(c(fit$Q)),
               c(0.4801153687413185, 0.3978818274266747, 0.0000000000000000, 0.0000000000000000, 0.3978818274266747, 0.4406743438864513, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000 ))

  expect_equal(unname(c(fit$Q_0)),
               c(1e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 1e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 1e+05, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 1e+05, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 1e-01, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 0e+00, 1e-01 ))

  expect_equal(unname(c(fit$n_risk)),
               c(400, 383, 346, 319, 293, 278, 261, 226, 161, 115 ))

  expect_equal(unname(c(fit$times)),
               c( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ))

  expect_equal(unname(c(fit$risk_set)),
               c(NULL ))

  expect_equal(unname(c(fit$data)),
               c(NULL ))

  expect_equal(unname(c(fit$order)),
               c(2 ))

  expect_equal(unname(c(fit$F_)),
               c( 2, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1,  0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0 ))

  expect_equal(unname(c(fit$method)),
               c("EKF" ))

  expect_equal(unname(c(fit$model)),
               c("logit" ))

  expect_equal(unname(c(fit$est_Q_0)),
               c(FALSE ))

  expect_equal(unname(c(fit$LR)),
               c(1 ))
})

test_that("Get loglike to work so you can use verbose with E-step fixed effects", {
  # There was a bug - thus this test is added
  expect_output(
    fit <- ddhazard(form, Q_0 = diag(c(rep(1, 2), rep(.1, 2))), Q = diag(.1, 2),
                    data = sims_logit$res, id = sims_logit$res$id,
                    by = 1, order = 2,
                    control = list(fixed_terms_method = "E_step",
                                   save_risk_set = F, save_data = F),
                    verbose = 5)
    , regexp = "Iteration\\s+\\d+\\sended with conv criteria\\s+\\d+.\\d+\\s+The log likelihood is\\s+")
})



set.seed(1534834)
sims_exp <- test_sim_func_exp(n_series = 4e2, n_vars = 3, x_range = 1, t_max = 10, x_mean = 0,
                              beta_start = 1, intercept_start = -3, is_fixed = 1:2)
# sum(sims_exp$res$event)

test_that("Works with UKF and continous time model", {
  fit <- suppressWarnings(ddhazard(form, Q_0 = diag(10, 2), Q = diag(1, 2),
                  data = sims_exp$res, id = sims_exp$res$id,
                  by = 1, model = "exp_bin", max_T = 10,
                  control = list(fixed_terms_method = "E_step",
                                 save_risk_set = F, save_data = F,
                                 method = "UKF")))

  # matplot(sims_exp$betas, lty = 1, type = "l",
  #         ylim = range(fit$fixed_effects, fit$state_vecs, sims_exp$betas))
  # matplot(fit$state_vecs, lty = 2, type = "l", add = T, col = 3:4)
  # abline(h = fit$fixed_effects, col = 1:2, lty = 2)
  # get_expect_equal(fit, eps = 1e-4)

  expect_equal(unname(c(fit$state_vecs)),
               c(0.3609891147388677, 0.3609529505871460, 0.2747309406733500, 1.1849209883891203, 1.1678193823589851, 1.8570646672504720, 1.3731407033728318, 1.2174543675658440, 1.1067613048724458, 1.7582654214966125, 1.1203839510803182, 0.1703754800640505, 0.1702537739464017, 0.4245929394253906, 1.7427855460474202, 1.7914160165065369, 2.4663444045402465, 1.3089587448982516, 0.5180000533001665, 0.4615656801386702, 1.5272808810682252, 0.5290258368905469 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$state_vars)),
               c(0.66416453717532420, 0.54154699163364928, 0.54154699163365272, 1.24629824258377475, 0.22072519541431718, 0.04041090329841174, 0.04041090329841572, 0.27451801917205149, 0.29787436203161388, 0.17087723710592195, 0.17087723710592601, 0.48510909721035528, 0.25102662578417251, 0.12473606363679896, 0.12473606363680326, 0.39075510739517699, 0.22092220840673771, 0.09787311300606391, 0.09787311300606830, 0.32363915321394848, 0.21947883942725580, 0.10511004166022934, 0.10511004166023394, 0.31971268255272689, 0.20135862013947861, 0.07777977165604465, 0.07777977165604945, 0.27252782810739851, 0.22838262125931774, 0.10561698246407261, 0.10561698246407772, 0.34568891243943622, 0.24618209824660470, 0.10863424182637807, 0.10863424182638320, 0.37979952506933029, 0.26825035339004139, 0.09163559784551353, 0.09163559784551872, 0.39812578580269664, 0.32277606995746366, 0.08277323686038729, 0.08277323686039229, 0.45535454940232389 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$lag_one_cov)),
               c(NULL )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$fixed_effects)),
               c(-3.054376954508364, 1.319806882329620 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$n_iter)),
               c(40 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$Q)),
               c(0.5166030355295625, 0.6205934329910607, 0.6205934329910607, 1.1835843815311333 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$Q_0)),
               c(10, 0, 0, 0, 0, 10, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$n_risk)),
               c(802, 725, 722, 658, 621, 585, 580, 511, 504, 465 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$times)),
               c( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$risk_set)),
               c(NULL )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$data)),
               c(NULL )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$order)),
               c(1 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$F_)),
               c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1 )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$method)),
               c("UKF" )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$model)),
               c("exp_bin" )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$est_Q_0)),
               c(FALSE )
               , tolerance = 1e-04)

  expect_equal(unname(c(fit$LR)),
               c(1 )
               , tolerance = 1e-04)
})

test_that("Works with second order random walk and continous time model",{
  fit <- suppressWarnings(ddhazard(form, Q_0 = diag(c(rep(10, 2), rep(1, 2))), Q = diag(1, 2),
                                   data = sims_exp$res, id = sims_exp$res$id,
                                   by = 1, model = "exp_bin", max_T = 10,
                                   control = list(fixed_terms_method = "E_step",
                                                  save_risk_set = F, save_data = F,
                                                  method = "UKF"),
                                   order = 2))

  # matplot(sims_exp$betas, lty = 1, type = "l",
  #         ylim = range(fit$fixed_effects, fit$state_vecs, sims_exp$betas))
  # matplot(fit$state_vecs[, 1:2], lty = 2, type = "l", add = T, col = 3:4)
  # abline(h = fit$fixed_effects, col = 1:2, lty = 2)
  # get_expect_equal(fit, eps = 1e-5, file = "tmp.txt")

  expect_equal(unname(c(fit$state_vecs)),
               c( 1.2975194842882629, 1.2409336575322942, 1.1811372778655129, 1.1585570513636105, 1.1767589522500685, 1.2572774733971321,  1.4172292543036691, 1.5886266788592820, 1.6606306820818084, 1.6632797945347895, 1.6910469114137123, -1.7437209791357711, -0.6488647281459874, 0.4733131123428205, 1.4373645470077714, 2.0911581564642261, 2.2401498072100421, 1.5713703714319736,  0.6910235876761135, 0.5246079672851602, 0.8983071988729838, 0.9640249852073437, 1.3525344243952053, 1.2975194842882629,  1.2409336575322942, 1.1811372778655129, 1.1585570513636105, 1.1767589522500685, 1.2572774733971321, 1.4172292543036691,  1.5886266788592820, 1.6606306820818084, 1.6632797945347895, -2.8252110840037190, -1.7437209791357711, -0.6488647281459874,  0.4733131123428205, 1.4373645470077714, 2.0911581564642261, 2.2401498072100421, 1.5713703714319736, 0.6910235876761135,  0.5246079672851602, 0.8983071988729838 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$state_vars)),
               c( 1.267786737480812e-01, -2.327837132250627e-02, 1.620089410054658e-01, -2.280883601930936e-02, -2.327837138217484e-02,  3.093829160651289e-01, -2.401882838818525e-02, 3.498204719139615e-01, 1.620089410054671e-01, -2.401882839116898e-02,  2.358493160799229e-01, -6.626570583876545e-02, -2.280883601632595e-02, 3.498204719139615e-01, -6.626570583891464e-02,  7.838091774008786e-01, 7.581003814739269e-02, -2.667828872177759e-03, 8.715787615103551e-02, 1.230368937425730e-03, -2.667829126538338e-03, 8.051362349518271e-02, 9.206275130429846e-05, 6.751068889770628e-02, 8.715787615083656e-02,  9.206287532908804e-05, 1.267786737480812e-01, -2.327837132250627e-02, 1.230368815052073e-03, 6.751068889790522e-02, -2.327837138217484e-02, 3.093829160651296e-01, 6.760850247665329e-02, -1.844371500145256e-02, 6.185826916050382e-02, -4.990824926681702e-04, -1.844371558576657e-02, 1.983503401313444e-01, -1.521375458731227e-03, 5.045936949459287e-02,  6.185826916030488e-02, -1.521375072383729e-03, 7.581003814739269e-02, -2.667828872177759e-03, -4.990828773645379e-04,  5.045936949479179e-02, -2.667829126538338e-03, 8.051362349518271e-02, 7.302540417569725e-02, -2.114266170600912e-02,  6.295703485902113e-02, -1.146833836343946e-02, -2.114266275553801e-02, 2.363582327790412e-01, -1.135513250565399e-02,  1.398533107584060e-01, 6.295703485882218e-02, -1.135513172172234e-02, 6.760850247665330e-02, -1.844371500145256e-02, -1.146833914571999e-02, 1.398533107586049e-01, -1.844371558576657e-02, 1.983503401313444e-01, 8.046133077798040e-02, -1.588707527781114e-02, 7.034553643304106e-02, -9.239434488046851e-03, -1.588707692781626e-02, 2.226816720365966e-01, -8.967968785396459e-03, 1.443453857820971e-01, 7.034553643284211e-02, -8.967967468619250e-03, 7.302540417569724e-02, -2.114266170600912e-02, -9.239435803172965e-03, 1.443453857822960e-01, -2.114266275553801e-02, 2.363582327790412e-01,  8.705281926006930e-02, -1.115369662317967e-02, 7.751051903173650e-02, -3.648545076988874e-03, -1.115369900892240e-02,  2.121972123368432e-01, -4.559032657883155e-03, 1.341371707041205e-01, 7.751051903153761e-02, -4.559030672999072e-03,  8.046133077798041e-02, -1.588707527781114e-02, -3.648547060221908e-03, 1.341371707043193e-01, -1.588707692781626e-02,  2.226816720365966e-01, 9.517804499537907e-02, -1.133892132971772e-02, 8.432419278444619e-02, 1.121704247388205e-03, -1.133892458645952e-02, 2.025815092559106e-01, -4.547245077581363e-03, 1.256029914812649e-01, 8.432419278424727e-02, -4.547242289328915e-03, 8.705281926006928e-02, -1.115369662317967e-02, 1.121701460786850e-03, 1.256029914814637e-01, -1.115369900892240e-02, 2.121972123368432e-01, 1.101389353442311e-01, -1.746810137569470e-02, 9.461942729729908e-02, -1.205006247655821e-06, -1.746810563869702e-02, 2.176411911178476e-01, -8.186383507040436e-03, 1.246822198064968e-01,  9.461942729710021e-02, -8.186379780158203e-03, 9.517804499537907e-02, -1.133892132971772e-02, -1.208731478796743e-06,  1.246822198066956e-01, -1.133892458645952e-02, 2.025815092559106e-01, 1.398148007415148e-01, -2.469777408995766e-02,  1.149311593338044e-01, -6.168333182119432e-03, -2.469777949448191e-02, 2.288603752139994e-01, -1.412935459415093e-02,  1.353494940084182e-01, 1.149311593336055e-01, -1.412934979337750e-02, 1.101389353442312e-01, -1.746810137569470e-02, -6.168337981241809e-03, 1.353494940086169e-01, -1.746810563869702e-02, 2.176411911178476e-01, 1.992187569656212e-01, -3.711982364946005e-02, 1.562994102119288e-01, -1.443440530365348e-02, -3.711983033076779e-02, 2.470931984181800e-01, -2.247528172667837e-02, 1.416478434655719e-01, 1.562994102117299e-01, -2.247527571675222e-02, 1.398148007415148e-01, -2.469777408995766e-02, -1.443441131192855e-02, 1.416478434657705e-01, -2.469777949448191e-02, 2.288603752139994e-01,  3.105862808242034e-01, -7.723365224902939e-02, 2.364408792814449e-01, -3.235096974034943e-02, -7.723366034238216e-02,  4.805107046510515e-01, -3.714057180037252e-02, 1.846377770242289e-01, 2.364408792812459e-01, -3.714056444603210e-02,  1.992187569656212e-01, -3.711982364946005e-02, -3.235097709303875e-02, 1.846377770244274e-01, -3.711983033076779e-02,  2.470931984181800e-01 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$lag_one_cov)),
               c(NULL )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$fixed_effects)),
               c(-3.045133496878786, 1.301733546912617 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$n_iter)),
               c(57 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$Q)),
               c( 0.01738414283101786, -0.06682576425916351, 0.00000000000000000, 0.00000000000000000, -0.06682576425916351, 0.57153259397573164,  0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,  0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$Q_0)),
               c(10, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$n_risk)),
               c(802, 725, 722, 658, 621, 585, 580, 511, 504, 465 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$times)),
               c( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$risk_set)),
               c(NULL )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$data)),
               c(NULL )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$order)),
               c(2 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$F_)),
               c( 2, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0 )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$method)),
               c("UKF" )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$model)),
               c("exp_bin" )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$est_Q_0)),
               c(FALSE )
               , tolerance = 1e-05)

  expect_equal(unname(c(fit$LR)),
               c(1 )
               , tolerance = 1e-05)
})

# Had issues with win builder. Thus, these lines
cat("\nFinished", test_name, "\n")
