% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{area.simulation.graph}
\alias{area.simulation.graph}
\title{Create an area graph of a simulated response in a dynardl model}
\usage{
area.simulation.graph(x, changes = FALSE, bw = FALSE)
}
\arguments{
\item{x}{a dynardl model with a simulation to be graphed}

\item{changes}{whether the graph should be shown in levels of the dependent variable or in changes in levels. The default is \code{FALSE}}

\item{bw}{should the colors be in black and white (for publication)? The default is \code{FALSE}}
}
\value{
an area graph
}
\description{
Create an area graph of a simulated response in a dynardl model
}
\details{
When running \code{dynardl}, \code{simulate} must be true so that there is a simulation to graph.
}
\examples{
# Using the ineq data in dynamac
# Shocking Income Top 10
ardl.model <- dynardl(concern ~ incshare10 + urate, data = ineq, 
       lags = list("concern" = 1, "incshare10" = 1),
       diffs = c("incshare10", "urate"), 
       lagdiffs = list("concern" = 1),
       ec = TRUE, simulate = TRUE, range = 30,
       shockvar = "incshare10", graph = FALSE)
area.simulation.graph(ardl.model)	# Shows absolute levels
area.simulation.graph(ardl.model, changes = TRUE)  # Shows changes from mean level
area.simulation.graph(ardl.model, bw = TRUE)	 # Grayscale plots
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
