/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.text;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities;

public class SelectOnEscapeWidget
extends LafWidgetAdapter {
    protected JTextComponent textComp;
    protected KeyListener keyListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.textComp = (JTextComponent)jcomp;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void installListeners() {
        this.keyListener = new KeyAdapter(){

            public void keyTyped(final KeyEvent e) {
                if (LafWidgetUtilities.hasTextFlipSelectOnEscapeProperty(SelectOnEscapeWidget.this.textComp) && e.getKeyChar() == '\u001b') {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int selectionLength = SelectOnEscapeWidget.this.textComp.getSelectionEnd() - SelectOnEscapeWidget.this.textComp.getSelectionStart();
                            if (selectionLength == 0) {
                                SelectOnEscapeWidget.this.textComp.selectAll();
                            } else {
                                SelectOnEscapeWidget.this.textComp.setCaretPosition(SelectOnEscapeWidget.this.textComp.getSelectionEnd());
                            }
                            SelectOnEscapeWidget.this.textComp.getParent().dispatchEvent(e);
                        }
                    });
                }
            }
        };
        this.textComp.addKeyListener(this.keyListener);
    }

    public void uninstallListeners() {
        this.keyListener = null;
        this.textComp.removeKeyListener(this.keyListener);
    }
}

