/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.utils.FadeTracker;

public class GhostingListener {
    protected ChangeListener modelListener;
    protected Component comp;
    protected ButtonModel buttonModel;
    protected Map<FadeTracker.FadeKind, Boolean> prevStateMap;

    public GhostingListener(Component comp, ButtonModel buttonModel) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.prevStateMap = new HashMap<FadeTracker.FadeKind, Boolean>();
        this.prevStateMap.put(FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER, buttonModel.isRollover());
        this.prevStateMap.put(FadeTracker.FadeKind.GHOSTING_BUTTON_PRESS, buttonModel.isPressed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeTracker.FadeKind fadeKind, boolean newState) {
        if (LafWidgetRepository.getRepository().getFadeIgnoreManager().toIgnoreAnimations(this.comp)) {
            return;
        }
        try {
            boolean prevState;
            if (this.prevStateMap.containsKey(fadeKind) && !(prevState = this.prevStateMap.get(fadeKind).booleanValue()) && newState) {
                FadeTracker.getInstance().trackFadeIn(fadeKind, this.comp, null, false, new FadeTracker.FadeTrackerCallback(){

                    protected void repaintParent(int x, int y, int width, int height) {
                        if (GhostingListener.this.comp == null) {
                            return;
                        }
                        if (GhostingListener.this.comp.getParent() == null) {
                            return;
                        }
                        GhostingListener.this.comp.getParent().repaint(x, y, width, height);
                    }

                    public void fadeEnded(FadeTracker.FadeKind fadeKind) {
                        Rectangle bounds = GhostingListener.this.comp.getBounds();
                        double iWidth = bounds.width * 2;
                        double iHeight = bounds.height * 2;
                        int dx = (int)((iWidth - (double)bounds.width) / 2.0);
                        int dy = (int)((iHeight - (double)bounds.height) / 2.0);
                        this.repaintParent(bounds.x - dx, bounds.y - dy, (int)iWidth, (int)iHeight);
                    }

                    public void fadePerformed(FadeTracker.FadeKind fadeKind, float fadeCycle10) {
                        Rectangle bounds = GhostingListener.this.comp.getBounds();
                        double iFactor = 1.0 + (double)fadeCycle10 / 10.0;
                        double iWidth = (double)bounds.width * iFactor;
                        double iHeight = (double)bounds.height * iFactor;
                        int dx = (int)((iWidth - (double)bounds.width) / 2.0);
                        int dy = (int)((iHeight - (double)bounds.height) / 2.0);
                        this.repaintParent(bounds.x - dx, bounds.y - dy, (int)iWidth, (int)iHeight);
                    }
                }, LafWidgetUtilities.getAnimationKind(this.comp));
            }
        }
        finally {
            this.prevStateMap.put(fadeKind, newState);
        }
    }

    public void registerListeners() {
        this.modelListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GhostingListener.this.trackModelChange(FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER, GhostingListener.this.buttonModel.isRollover());
                GhostingListener.this.trackModelChange(FadeTracker.FadeKind.GHOSTING_BUTTON_PRESS, GhostingListener.this.buttonModel.isPressed());
            }
        };
        this.buttonModel.addChangeListener(this.modelListener);
    }

    public void unregisterListeners() {
        this.buttonModel.removeChangeListener(this.modelListener);
    }
}

