/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.ContinueAnalysee;
import don.DonneeID;
import don.DonneeMoyenne;
import don.Groupe;
import exceptions.ExceptionIntegrite;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinueMoyenne
extends ContinueAnalysee
implements DonneeMoyenne {
    private static final long serialVersionUID = 8682264074537419185L;
    private Vector<ContinueAnalysee> m_branches;

    public ContinueMoyenne(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, boolean orthonorme) {
        super(annotation, active, gr, coord, cos2, contrib, orthonorme);
        this.m_branches = new Vector();
    }

    public ContinueMoyenne(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, boolean orthonorme, Vector<ContinueAnalysee> branches) {
        super(annotation, active, gr, coord, cos2, contrib, orthonorme);
        this.m_branches = branches;
    }

    @Override
    public Vector<DonneeID> getBranches() {
        return new Vector<DonneeID>(this.m_branches);
    }

    public ContinueAnalysee get(int i) {
        return this.m_branches.get(i);
    }

    public void setBranches(Vector<ContinueAnalysee> branches) {
        this.m_branches = branches;
    }

    public void addBranche(ContinueAnalysee fille) {
        this.m_branches.add(fille);
    }

    @Override
    public int getNbBranches() {
        return this.m_branches.size();
    }

    public ContinueAnalysee getVariable(String annot) {
        ContinueAnalysee trouve = null;
        if (this.getAnnotation().equals(annot)) {
            trouve = this;
        } else {
            int i = 0;
            while (i < this.getNbBranches() && trouve == null) {
                ContinueAnalysee temp = this.m_branches.elementAt(i);
                if (temp instanceof ContinueMoyenne) {
                    trouve = ((ContinueMoyenne)temp).getVariable(annot);
                } else if (temp.getAnnotation().equals(annot)) {
                    trouve = temp;
                }
                ++i;
            }
        }
        return trouve;
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        super.verifierIntegrite();
        for (ContinueAnalysee var : this.m_branches) {
            var.verifierIntegrite();
        }
    }
}

