/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import don.DonneeID;
import don.Modalite;
import ihm.Gestionnaire;
import ihm.IHM;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import outils.Constantes;

public class RenduDonneeID
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = -4503481361185338287L;
    private Gestionnaire m_gestionnaire;
    private JLabel icone_fantome;
    private JLabel icone_illus;
    private JLabel texte;

    public RenduDonneeID(Gestionnaire gestionnaire) {
        this.m_gestionnaire = gestionnaire;
        this.setLayout(new FlowLayout(3, 0, 0));
        this.icone_fantome = new JLabel();
        this.icone_illus = new JLabel();
        this.texte = new JLabel();
        this.icone_fantome.setOpaque(true);
        this.icone_illus.setOpaque(true);
        this.texte.setOpaque(true);
        this.texte.setHorizontalTextPosition(2);
        this.add(this.icone_fantome);
        this.add(this.icone_illus);
        this.add(this.texte);
    }

    public Component getListCellRendererComponent(JList arg0, Object element, int arg2, boolean arg3, boolean arg4) {
        if (element instanceof DonneeID) {
            String statut = "";
            if (this.m_gestionnaire.isFantome((DonneeID)element)) {
                this.icone_fantome.setIcon(new ImageIcon(String.valueOf(IHM.m_dir) + Constantes.ICONE_FANTOME));
                statut = String.valueOf(statut) + IHM.getXmlLangue().getElement("LInvisible");
            } else {
                this.icone_fantome.setIcon(new ImageIcon(String.valueOf(IHM.m_dir) + Constantes.ICONE_NON_FANTOME));
                statut = String.valueOf(statut) + IHM.getXmlLangue().getElement("LVisible");
            }
            statut = String.valueOf(statut) + " " + IHM.getXmlLangue().getElement("et") + " ";
            if (((DonneeID)element).isActive()) {
                this.icone_illus.setIcon(new ImageIcon(String.valueOf(IHM.m_dir) + Constantes.ICONE_ACTIF));
                statut = String.valueOf(statut) + IHM.getXmlLangue().getElement("CactifMF");
            } else {
                this.icone_illus.setIcon(new ImageIcon(String.valueOf(IHM.m_dir) + Constantes.ICONE_ILLUSTRATIF));
                statut = String.valueOf(statut) + IHM.getXmlLangue().getElement("CillusMF");
            }
            this.setToolTipText(statut);
            if (element instanceof Modalite) {
                Modalite mod = (Modalite)element;
                this.texte.setText(String.valueOf(mod.getNominale().getAnnotation()) + " : " + mod.getAnnotation());
            } else {
                this.texte.setText(((DonneeID)element).getAnnotation());
            }
        }
        return this;
    }

    public String getText() {
        return this.texte.getText();
    }
}

