/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.ExtendedStatistics;
import jas.hist.HasDataSource;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;
import jas.hist.TwoDOverlay;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import java.util.Observable;

class JASHist2DHistogramData
extends JASHistData {
    protected Rebinnable2DHistogramData dataSource;
    protected JASHist2DHistogramStyle style;
    protected boolean hurry;
    protected boolean dataValid;
    boolean isBinned = false;
    private boolean zLimitsValid = false;
    private double[][] data;
    private int xBins;
    private double xLow;
    private double xHigh;
    private int yBins;
    private double yLow;
    private double yHigh;
    private double zMin;
    private double zMax;

    JASHist2DHistogramData(DataManager dm, Rebinnable2DHistogramData ds) {
        super(dm);
        this.dataSource = ds;
        this.initTransientData();
        JASHistStyle s = null;
        if (ds instanceof HasStyle) {
            s = ((HasStyle)((Object)ds)).getStyle();
        }
        if (s == null) {
            s = this.createStyle();
        }
        this.setStyle(s);
        String property = System.getProperty("hurry", "false");
        this.hurry = property != null && property.equalsIgnoreCase("true");
    }

    JASHistStyle createStyle() {
        return new JASHist2DHistogramStyle();
    }

    private void initTransientData() {
        this.zLimitsValid = false;
        this.isBinned = false;
    }

    public void setStyle(JASHistStyle style) {
        if (!(style instanceof JASHist2DHistogramStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist2DHistogramStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist2DHistogramStyle)style;
        this.style.addObserver(this);
    }

    public String getTitle() {
        return this.dataSource.getTitle();
    }

    Overlay createOverlay() {
        return new TwoDOverlay(this);
    }

    void writeAsXML(XMLPrintWriter pw, boolean snapshot) {
        String theXAxisType = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getXAxisType());
        String theYAxisType = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getYAxisType());
        pw.setAttribute("type", "histogram2d");
        pw.openTag("data2d");
        if (snapshot) {
            Statistics stats;
            boolean haveMinusError;
            double[][][] result = this.dataSource.rebin(this.xBins, this.xLow, this.xHigh, this.yBins, this.yLow, this.yHigh, true, this.hurry, this.style.getShowOverflow());
            if (result == null) {
                result = new double[1][this.xBins][this.yBins];
            }
            double[][] data = result[0];
            pw.setAttribute("title", this.getTitle());
            pw.setAttribute("xSize", data.length);
            pw.setAttribute("ySize", data[0].length);
            pw.openTag("bins2d");
            double[][] positiveError = new double[0][0];
            double[][] negativeError = new double[0][0];
            boolean havePlusError = result.length > 1;
            boolean bl = haveMinusError = result.length > 2;
            if (havePlusError) {
                positiveError = result[1];
                if (haveMinusError) {
                    negativeError = result[2];
                }
            }
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    pw.print(data[i][j]);
                    if (havePlusError && positiveError.length > i && positiveError[i].length > j) {
                        pw.print("," + positiveError[i][j]);
                        if (haveMinusError && negativeError.length > i && negativeError[i].length > j) {
                            pw.println("," + negativeError[i][j]);
                            continue;
                        }
                        pw.println();
                        continue;
                    }
                    pw.println();
                }
            }
            pw.closeTag();
            pw.printBinnedDataAxisAttributes("x", "" + this.getXMin(), "" + this.getXMax(), "" + this.dataSource.getXBins(), theXAxisType);
            pw.printBinnedDataAxisAttributes("y", "" + this.getYMin(), "" + this.getYMax(), "" + this.dataSource.getYBins(), theYAxisType);
            if (this.dataSource instanceof HasStatistics && (stats = ((HasStatistics)((Object)this.dataSource)).getStatistics()) != null) {
                pw.openTag("statistics");
                String[] names = stats.getStatisticNames();
                for (int i = 0; i < names.length; ++i) {
                    Object value;
                    String name = names[i];
                    pw.setAttribute("name", name);
                    String valueString = null;
                    if (stats instanceof ExtendedStatistics && (value = ((ExtendedStatistics)stats).getExtendedStatistic(name)) != null) {
                        valueString = value.toString();
                    }
                    if (valueString == null) {
                        valueString = String.valueOf(stats.getStatistic(name));
                    }
                    pw.setAttribute("value", valueString);
                    pw.printTag("statistic");
                }
                pw.closeTag();
            }
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(pw);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                pw.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                pw.setAttribute("name", "???");
            }
            pw.setAttribute("param", "???");
            pw.printTag("class");
        }
        String histStyleName = JASHist2DHistogramStyle.getHistStyleName(this.style.getHistStyle());
        pw.setAttribute("histStyle", histStyleName);
        if (histStyleName.equals("STYLE_COLORMAP")) {
            pw.setAttribute("colorMapScheme", JASHist2DHistogramStyle.getColorMapSchemeName(this.style.getColorMapScheme()));
        }
        pw.setAttribute("shapeColor", ColorConverter.colorToString(this.style.getShapeColor()));
        pw.setAttribute("overflowBinColor", ColorConverter.colorToString(this.style.getOverflowBinColor()));
        pw.setAttribute("startDataColor", ColorConverter.colorToString(this.style.getStartDataColor()));
        pw.setAttribute("endDataColor", ColorConverter.colorToString(this.style.getEndDataColor()));
        pw.setAttribute("showOverflow", this.style.getShowOverflow());
        pw.setAttribute("showPlot", this.style.getShowPlot());
        if (this.style.getLogZ()) {
            pw.setAttribute("logZ", true);
        }
        pw.printTag("style2d");
        pw.closeTag();
    }

    boolean isRebinnable() {
        return this.dataSource.isRebinnable();
    }

    double getXMin() {
        double result = this.dataSource.getXMin();
        if (this.style.getShowOverflow()) {
            result -= (this.dataSource.getXMax() - result) / (double)this.dataSource.getXBins();
        }
        return result;
    }

    double getXMax() {
        double result = this.dataSource.getXMax();
        if (this.style.getShowOverflow()) {
            result += (result - this.dataSource.getXMin()) / (double)this.dataSource.getXBins();
        }
        return result;
    }

    double getYMin() {
        double result = this.dataSource.getYMin();
        if (this.style.getShowOverflow()) {
            result -= (this.dataSource.getYMax() - result) / (double)this.dataSource.getYBins();
        }
        return result;
    }

    double getYMax() {
        double result = this.dataSource.getYMax();
        if (this.style.getShowOverflow()) {
            result += (result - this.dataSource.getYMin()) / (double)this.dataSource.getYBins();
        }
        return result;
    }

    int getXBins() {
        return this.dataSource.getXBins();
    }

    int getYBins() {
        return this.dataSource.getYBins();
    }

    void setXRange(int xBins, double xLow, double xHigh) {
        if (this.isRebinnable()) {
            if (xBins != this.xBins || xLow != this.xLow || xHigh != this.xHigh) {
                this.xBins = xBins;
                this.isBinned = false;
                this.zLimitsValid = false;
            }
        } else {
            this.xBins = this.dataSource.getXBins();
        }
        this.xLow = xLow;
        this.xHigh = xHigh;
    }

    void setYRange(int yBins, double yLow, double yHigh) {
        if (this.isRebinnable()) {
            if (yBins != this.yBins || yLow != this.yLow || yHigh != this.yHigh) {
                this.yBins = yBins;
                this.isBinned = false;
                this.zLimitsValid = false;
            }
        } else {
            this.yBins = this.dataSource.getYBins();
        }
        this.yLow = yLow;
        this.yHigh = yHigh;
    }

    private void doBin() {
        double yh;
        double yl;
        double xh;
        double xl;
        this.isBinned = true;
        if (this.isRebinnable()) {
            xl = this.xLow;
            xh = this.xHigh;
            yl = this.yLow;
            yh = this.yHigh;
        } else {
            xl = this.dataSource.getXMin();
            xh = this.dataSource.getXMax();
            yl = this.dataSource.getYMin();
            yh = this.dataSource.getYMax();
        }
        double[][][] result = this.dataSource.rebin(this.xBins, xl, xh, this.yBins, yl, yh, true, this.hurry, this.style.getShowOverflow());
        if (result == null) {
            result = new double[1][this.xBins][this.yBins];
        }
        if (this.normalization != null) {
            double factor = 1.0 / this.normalization.getNormalizationFactor();
            for (int k = 0; k < result.length; ++k) {
                double[][] yy = result[k];
                for (int j = 0; j < yy.length; ++j) {
                    double[] y = yy[j];
                    int i = 0;
                    while (i < y.length) {
                        int n = i++;
                        y[n] = y[n] * factor;
                    }
                }
            }
        }
        this.data = result[0];
        if (this.data.length != this.xBins) {
            System.err.println("Warning xbins=" + this.xBins + " data.length=" + this.data.length);
        }
        if (this.overlay instanceof TwoDOverlay) {
            ((TwoDOverlay)this.overlay).setData(this.data, xl, xh, yl, yh, this.xBins, this.yBins);
        }
    }

    protected void calcZLimits() {
        double zLogMin;
        if (!this.isBinned) {
            this.doBin();
        }
        this.zLimitsValid = true;
        if (this.xBins == 0 || this.yBins == 0) {
            this.zMin = 0.0;
            zLogMin = Double.POSITIVE_INFINITY;
            this.zMax = 1.0;
        } else {
            zLogMin = Double.POSITIVE_INFINITY;
            this.zMin = Double.POSITIVE_INFINITY;
            this.zMax = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < this.data[0].length; ++j) {
                for (int i = 0; i < this.data.length; ++i) {
                    double d = this.data[i][j];
                    this.zMin = Math.min(this.zMin, d);
                    if (d > 0.0) {
                        zLogMin = Math.min(zLogMin, d);
                    }
                    this.zMax = Math.max(this.zMax, d);
                }
            }
        }
        if (this.overlay instanceof TwoDOverlay) {
            ((TwoDOverlay)this.overlay).setZMinMax(this.zMin, this.zMax, zLogMin);
        }
    }

    public void update(Observable o, Object arg) {
        if (o == this.dataSource) {
            HistogramUpdate hu = (HistogramUpdate)arg;
            this.isBinned = false;
            this.zLimitsValid = false;
            this.parent.update(hu, this);
        } else if (o == this.style) {
            this.isBinned = false;
            this.parent.styleUpdate(this);
        } else if (o == this.normalization) {
            this.normalizationChanged(false);
        }
    }

    void normalizationChanged(boolean now) {
        this.isBinned = false;
        this.zLimitsValid = false;
        this.parent.update(null, this);
    }

    public boolean hasChanged() {
        return !this.isBinned;
    }

    void validate() {
        if (!this.isBinned) {
            this.doBin();
        }
        System.out.println("validate called");
    }

    void axisChanged() {
        this.parent.axisChanged(this);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    void destroy() {
        if (this.dataSource instanceof Observable) {
            ((Observable)((Object)this.dataSource)).deleteObserver(this);
        }
        this.style.deleteObserver(this);
        super.deleteNormalizationObserver();
    }
}

