% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.grid.nodup.R
\name{expand.grid.nodup}
\alias{expand.grid.nodup}
\title{Combinations without duplications}
\usage{
expand.grid.nodup(lst, max = 1e+05)
}
\arguments{
\item{lst}{A list of vectors.}

\item{max}{A positive integer. If the number of combinations (according to a
preliminary lower bound) exceeds this, the function aborts with an
informative error message. Default: 1e5.}
}
\value{
A data frame.
}
\description{
This is similar to \code{\link[=expand.grid]{expand.grid()}} except that combinations with repeated
elements are not included. The element "*" is treated separately, and is
allowed to be repeated.
}
\examples{

lst = list(1, 1:2, 3:4)

# Compare
expand.grid.nodup(lst)
expand.grid(lst)

# Typical use case for DVI
lst2 = generatePairings(example1)
expand.grid.nodup(lst2)

}
\seealso{
\code{\link[=expand.grid]{expand.grid()}}
}
