% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_duke_continuous.R
\name{scale_duke_continuous}
\alias{scale_duke_continuous}
\title{Continuous scale constructor.}
\usage{
scale_duke_continuous(
  ...,
  low = "#00539B",
  high = "#E2E6ED",
  space = "Lab",
  na.value = "#666666",
  guide = "colourbar",
  aesthetics = c("colour", "color", "fill")
)
}
\arguments{
\item{...}{Arguments passed on to \href{https://ggplot2.tidyverse.org/reference/continuous_scale.html?q=continuous_scale}{continuous_scale()}.}

\item{low}{Low end of color gradient.}

\item{high}{High end of color gradient.}

\item{space}{Color space in which to calculate gradient.}

\item{na.value}{Color used for NA values.}

\item{guide}{Type of legend. "colorbar" for continuous scale, "legend" for discrete scale.}

\item{aesthetics}{String or vector of strings detailing what aesthetic features this continuous scale can apply to.}
}
\value{
a visualization with continuous duke color scale
}
\description{
Applies a Duke branded and accessible continuous color scale to ggplot
geometric objects. It is applicable for both fill and color arguments.
Defines gradient scale from dark to light to improve visibility and contrast
for readers.
}
\examples{
library(ggplot2)
library(palmerpenguins)

# default
ggplot(penguins, aes(x = bill_depth_mm, y = bill_length_mm, color = body_mass_g)) +
  geom_point()

# vs. with Duke scale
ggplot(penguins, aes(x = bill_depth_mm, y = bill_length_mm, color = body_mass_g)) +
  geom_point() +
  scale_duke_continuous()
}
