% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cached_connection.R
\name{cached_connection}
\alias{cached_connection}
\title{create a cachable duckdb connection}
\usage{
cached_connection(
  dbdir = ":memory:",
  read_only = FALSE,
  bigint = "numeric",
  config = list(temp_directory = tempfile()),
  autoload_exts = getOption("duckdbfs_autoload_extensions", TRUE)
)
}
\arguments{
\item{dbdir}{Location for database files. Should be a path to an existing
directory in the file system. With the default (or \code{""}), all
data is kept in RAM.}

\item{read_only}{Set to \code{TRUE} for read-only operation.
For file-based databases, this is only applied when the database file is opened for the first time.
Subsequent connections (via the same \code{drv} object or a \code{drv} object pointing to the same path)
will silently ignore this flag.}

\item{bigint}{How 64-bit integers should be returned. There are two options: \code{"numeric"} and \code{"integer64"}.
If \code{"numeric"} is selected, bigint integers will be treated as double/numeric.
If \code{"integer64"} is selected, bigint integers will be set to bit64 encoding.}

\item{config}{Named list with DuckDB configuration flags, see
\url{https://duckdb.org/docs/configuration/overview#configuration-reference} for the possible options.
These flags are only applied when the database object is instantiated.
Subsequent connections will silently ignore these flags.}

\item{autoload_exts}{should we auto-load extensions?  TRUE by default,
can be configured with \code{options(duckdbfs_autoload_extensions = FALSE)}}
}
\value{
a \code{\link[duckdb:duckdb]{duckdb::duckdb()}} connection object
}
\description{
This function is primarily intended for internal use by other
\code{duckdbfs} functions.  However, it can be called directly by
the user whenever it is desirable to have direct access to the
connection object.
}
\details{
When first called (by a user or internal function),
this function both creates a duckdb connection and places
that connection into a cache (\code{duckdbfs_conn} option).
On subsequent calls, this function returns the cached connection,
rather than recreating a fresh connection.

This frees the user from the responsibility of managing a
connection object, because functions needing access to the
connection can use this to create or access the existing connection.
At the close of the global environment, this function's finalizer
should gracefully shutdown the connection before removing the cache.

By default, this function creates an in-memory connection. When reading
from on-disk or remote files (parquet or csv), this option can still
effectively support most operations on much-larger-than-RAM data.
However, some operations require additional working space, so by default
we set a temporary storage location in configuration as well.
}
\examples{

con <- cached_connection()
close_connection(con)

}
