% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relational.R
\name{rel_filter}
\alias{rel_filter}
\title{Lazily filter a DuckDB relation object}
\usage{
rel_filter(rel, exprs)
}
\arguments{
\item{rel}{the DuckDB relation object}

\item{exprs}{a list of DuckDB expressions to filter by}
}
\value{
the now filtered \code{duckdb_relation} object
}
\description{
Lazily filter a DuckDB relation object
}
\examples{
con <- DBI::dbConnect(duckdb())
DBI::dbExecute(con, 'CREATE MACRO gt(a, b) AS a > b')
rel <- rel_from_df(con, mtcars)
rel2 <- rel_filter(rel, list(expr_function("gt", list(expr_reference("cyl"), expr_constant("6")))))
}
