% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MathFun.R
\docType{methods}
\name{MathFun}
\alias{MathFun}
\alias{abs,dual-method}
\alias{sqrt,dual-method}
\title{Miscellaneous Mathematical Functions}
\usage{
\S4method{sqrt}{dual}(x)

\S4method{abs}{dual}(x)
}
\arguments{
\item{x}{a dual object or numeric value.}
}
\value{
A dual object containing the transformed values according to the chosen function.
}
\description{
The function \code{abs(x)} computes the absolute value of \code{x}, 
while \code{sqrt(x)} computes the square root of \code{x}.
}
\examples{
x <- dual(4.3, 1:0)
y <- dual(7.6, 0:1)
abs(-2.2 * x + 0.321 * y)
sqrt(y - x)

}
