% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/twdtw.R
\docType{methods}
\name{mtwdtw}
\alias{mtwdtw}
\title{Performs multiple Time-Weighted DTW}
\usage{
mtwdtw(query, template, ...)
}
\arguments{
\item{query}{A \link[zoo]{zoo} object with a query time series}

\item{template}{A \link[zoo]{zoo} object with a template time series similar
to \code{query}. The \code{template} must have the same number of attributes
and be equal to or longer than the \code{query}}

\item{...}{additional arguments passed to \code{\link[dtwSat]{twdtw}}}
}
\value{
An object of class \link[dtwSat]{dtwSat-class} without \code{internals}
or \code{mapping}
}
\description{
This function performs the Time-Weighted DTW for a list
of queries
}
\examples{
alig = mtwdtw(query.list, template, weight = "logistic",
       alpha = 0.1, beta = 100)
alig
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtw}}, \code{\link[dtwSat]{dtwSat-class}}
}

