% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{methods}
\name{classfyIntervals}
\alias{classfyIntervals}
\title{Classify time intervals}
\usage{
classfyIntervals(x, from, to, by, breaks = NULL, normalized = TRUE,
  overlap = 0.7, threshold = Inf)
}
\arguments{
\item{x}{A \code{\link[dtwSat]{dtwSat}} object or
a \code{\link[base]{data.frame}} similar to the slot \code{alignments} in
object \code{\link[dtwSat]{dtwSat-class}}}

\item{from}{A \code{\link[base]{Date}} object}

\item{to}{A \code{\link[base]{Date}} object}

\item{by}{A character with the intevals size, \emph{e.g.} ''6 month''}

\item{breaks}{A vector of class \code{\link[base]{Date}}}

\item{normalized}{Use normalized TWDTW distance. Default is TRUE}

\item{overlap}{A number between 0 and 1. The minimum overlapping
between the one alignment and the interval of classification.
Default is 1, \emph{i.e.} 100\%}

\item{threshold}{A number. The TWDTW threshold, i.e. the maximum TWDTW
cost for consideration. Default is \code{Inf}}
}
\value{
object of class \code{\link[base]{data.frame}} with the best alignment
for each interval
}
\description{
This function retrieves the best alignment within each
interval of classification based on the TWDTW distance
}
\examples{
malig = mtwdtw(query.list, template, weight = "logistic",
         alpha = 0.1, beta = 100)

# Classify interval
from = as.Date("2009-09-01")
to = as.Date("2013-09-01")
best_class = classfyIntervals(x=malig, from=from, to=to, by = "6 month",
             normalized=TRUE, overlap=.5, threshold=Inf)
best_class
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}

