% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{distinct.trackr_df}
\alias{distinct.trackr_df}
\title{Distinct values of data}
\usage{
\method{distinct}{trackr_df}(
  .data,
  ...,
  .messages = "removing {.count.in-.count.out} duplicates",
  .headline = .defaultHeadline(),
  .tag = NULL
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Optional variables to
use when determining uniqueness. If there are multiple rows for a given
combination of inputs, only the first row will be preserved. If omitted,
will use all variables in the data frame.}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, or \{.strata\},\{.count.in\},and \{.count.out\}}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, or \{.strata\},\{.count.in\},and \{.count.out\}}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the .data dataframe with distinct values and history graph updated.
}
\description{
Distinct acts in the same way as in \code{dplyr::distinct}. Prior to the operation
the size of the group is calculated \{.count.in\} and after the operation the
output size \{.count.out\} The group \{.strata\} is also available (if
grouped) for reporting. See \code{\link[dplyr:distinct]{dplyr::distinct()}}.
}
\examples{
library(dplyr)
library(dtrackr)

tmp = bind_rows(iris \%>\% track(), iris \%>\% track() \%>\% filter(Petal.Length > 5))
tmp \%>\% group_by(Species) \%>\% distinct() \%>\% history()
}
\seealso{
dplyr::distinct()
}
