% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_DTRSurv.R
\name{stage}
\alias{stage}
\alias{stage,DTRSurv-method}
\title{Retrieve Stage Results as a List}
\usage{
stage(object, ...)

\S4method{stage}{DTRSurv}(object, ..., q)
}
\arguments{
\item{object}{A DTRSurv object. The value returned by dtrSurv().}

\item{...}{Ignored. Used to require named inputs.}

\item{q}{An integer object. (optional) The stage for which results are 
desired. If q is not provided, all stage results will be returned.}
}
\value{
A list object containing the key results for each requested stage.
  If q is not provided, a list of these results will be returned, where the
  ith element of that list corresponds to the ith decision point.
}
\description{
Returns the key results from all stages or one stage of the Q-learning algorithm.
}
\examples{


dt <- data.frame("Y.1" = sample(1:100,100,TRUE), "Y.2" = sample(101:200,100,TRUE),
                 "D.1" = rbinom(100, 1, 0.9), "D.2" = rbinom(100,1,0.9),
                 "A.1" = rbinom(100, 1, 0.5), "A.2" = rbinom(100,1,0.5),
                 "X.1" = rnorm(100), "X.2" = rnorm(100))

# responses must be zero after event
evt <- dt[,"D.1"] == 1L
dt[evt, "Y.2"] <- 0.0

result <- dtrSurv(data = dt, 
                  txName = c("A.1", "A.2"), 
                  models = list(Surv(Y.1,D.1)~X.1+A.1, 
                                Surv(Y.2,D.2)~X.2+A.2+Y.1))

tt <- stage(object = result)
}
