% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linComb.R
\name{helper_minmax}
\alias{helper_minmax}
\title{Helper function for minmax method.}
\usage{
helper_minmax(lambda, neg.set, pos.set)
}
\arguments{
\item{lambda}{a \code{numeric} parameter that will be estimated in minmax
method for the combination score}

\item{neg.set}{a \code{numeric} data frame that contains the observations
with negative status}

\item{pos.set}{a \code{numeric} data frame that contains the observations
with positive status}
}
\value{
A \code{numeric} value for the estimated optimized value
}
\description{
The \code{helper_minmax} function estimates optimized value of
given biomarkers for the minmax method.
}
\examples{
# call data
data(laparoscopy)

# define the function parameters
markers <- cbind(laparoscopy$ddimer, laparoscopy$log_leukocyte)
status <- factor(laparoscopy$group, levels = c("not_needed", "needed"))

neg.set <- markers[status == levels(status)[1], ]
pos.set <- markers[status == levels(status)[2], ]

lambda <- 0.5

stat <- helper_minmax(lambda, neg.set = neg.set, pos.set = pos.set)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
