% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqgam.check.R
\name{rqgam.check}
\alias{rqgam.check}
\title{Randomised quantile residuals check plot for GAMs/DSMs}
\usage{
rqgam.check(gam.obj, ...)
}
\arguments{
\item{gam.obj}{a \code{gam}, \code{glm} or \code{dsm} object.}

\item{...}{arguments passed on to all plotting functions}
}
\value{
just plots!
}
\description{
Reproduces the "Resids vs. linear pred" plot from \code{\link{gam.check}} but using randomised quantile residuals, a la Dunn and Smyth (1996). Checks for heteroskedasticity as as usual, looking for "funnel"-type structures in the points, which is much easier with randomised quantile residuals than with deviance residuals, when your model uses a count distribution as the response.
}
\details{
Note that this function only works with negative binomial and Tweedie response distributions.

Earlier versions of this function produced the full \code{gam.check} output, but this was confusing as only one of the plots was really useful. Checks of \code{k} are not computed, these need to be done using \code{\link{gam.check}}.
}
\examples{
\donttest{
library(Distance)
library(dsm)
library(tweedie)

# load the Gulf of Mexico dolphin data (see ?mexdolphins)
data(mexdolphins)

# fit a detection function and look at the summary
hr.model <- ds(distdata, max(distdata$distance),
               key = "hr", adjustment = NULL)

# fit a simple smooth of x and y with a Tweedie response with estimated
#  p parameter
mod1 <- dsm(count~s(x, y), hr.model, segdata, obsdata, family=tw())
rqgam.check(mod1)
}
}
\author{
Based on code provided by Natalie Kelly, bugs added by Dave Miller
}
