#' US gun murders by state for 2010
#' 
#' Gun murder data are from FBI reports. Also contains the population of each state.
#'
#' \itemize{
#'  \item state. US state
#'  \item abb. Abbreviation of US state
#'  \item region. Geographical US region
#'  \item population. State population (2010)
#'  \item total. Number of gun murders in state (2010)
#' }
#'
#' @docType data
#'
#' @usage data(murders)
#'
#' @format An object of class \code{"data.frame"}. 
#'
#' @keywords datasets
#'
#'
#' @source \href{https://en.wikipedia.org/wiki/Murder_in_the_United_States_by_state}{Wikipedia}
#'
#' @examples
#' data(murders)
#' print(murders)
"murders"