% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcop.R
\name{dcop}
\alias{dcop}
\alias{pcop}
\alias{rcop}
\title{Copula function}
\usage{
dcop(
  W,
  delta,
  distr_cop = "normal",
  rot = 0,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

pcop(W, delta = 0, distr_cop = "normal", rot = 0, log.p = FALSE)

rcop(n, delta = 0, distr_cop = "normal", rot = 0)
}
\arguments{
\item{W}{numeric matrix of pseudo observations. Must have two columns.}

\item{delta}{numeric vector of copula parameter \eqn{\delta}.}

\item{distr_cop}{string, defines the copula family:\cr
\code{independent} = Independence copula \cr
\code{normal} = Gaussian copula \cr
\code{clayton} = Clayton copula \cr
\code{gumbel} = Gumbel copula \cr
\code{frank} = Frank copula \cr
\code{joe} = Joe copula \cr
\code{amh} = Ali-Mikhail-Haq copula \cr}

\item{rot, }{integer determining the rotation for Archimedian copulas. Can be \code{90}, \code{180} or \code{270}.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional; index matrix for upper triangular, generated by \code{\link[=trind_generator]{trind_generator()}}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{positive integer; number of observations.}
}
\value{
\code{dcop} gives the density, \code{pcop} gives the distribution function for a specified copula and \code{rcop} generates random numbers, with given \code{delta}.
\code{dcop()} returns a \code{derivs} object. For more details see \code{\link[=trind]{trind()}} and \code{\link[=trind_generator]{trind_generator()}}.
}
\description{
Probablitiy density function, distribution and random number generation for copulas.
}
\details{
A two-dimensional copula \eqn{C(w_1, w_2, \delta)} is a multivariate cumulative distribution function for which the marginal probability distribution of \eqn{w_1} and \eqn{w_1} are uniform on the interval \eqn{[0,1]}.
The parameter \eqn{\delta} specifies the copula.

The functions \code{pcop()} and \code{rcop()} are wrapper functions for the \code{\link[copula:pCopula]{pCopula()}} and \code{\link[copula:rCopula]{rCopula()}}.
}
\section{Functions}{
\itemize{
\item \code{pcop()}: distribution function for copula.

\item \code{rcop()}: random number generation for copula.

}}
\examples{
u=0.3; v=0.7; p=0.5
pdf <- dcop(W=cbind(u,v), delta=p, distr_cop="normal")
cdf <- pcop(W=cbind(u,v), delta=p, distr_cop="normal")
r <- rcop(n=100, delta=p, distr_cop="normal")

}
\references{
\itemize{
\item \insertRef{schepsmeier2014derivatives}{dsfa}
\item \insertRef{hofert2018elements}{dsfa}
}
}
\seealso{
Other copula: 
\code{\link{cop}()},
\code{\link{delta_bounds}()}
}
\concept{copula}
