% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.bind_rows.R
\name{ds.bind_rows}
\alias{ds.bind_rows}
\title{Bind multiple data frames by row.}
\usage{
ds.bind_rows(to_combine = NULL, .id = NULL, newobj = NULL, datasources = NULL)
}
\arguments{
\item{to_combine}{Data frames to combine. Each argument can either be a data frame, a list that
could be a data frame, or a list of data frames. Columns are matched by name, and any missing
columns will be filled with NA.}

\item{.id}{The name of an optional identifier column. Provide a string to create an output column
that identifies each input. The column will use names if available, otherwise it will use
positions.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{datashield connections object.}
}
\value{
No return value, called for its side effects. A data frame with the name specified by
\code{newobj} and the same type as the first element of \code{to_combine} is created on the
server.
}
\description{
DataSHIELD implementation of \code{dplyr::bind_rows}.
}
\examples{
\dontrun{
## First log in to a DataSHIELD session with mtcars dataset loaded.

ds.bind_rows(
  to_combine = list(mtcars, mtcars),
  newobj = "test",
  datasources = conns
)

## Refer to the package vignette for more examples.
}
}
