% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{count_words}
\alias{count_words}
\title{Count the frequency of words in a string of text \code{x}.}
\usage{
count_words(x, case_sense = TRUE, sort_freq = TRUE)
}
\arguments{
\item{x}{A string of text (required).}

\item{case_sense}{Boolean: Distinguish lower- vs. uppercase characters? 
Default: \code{case_sense = TRUE}.}

\item{sort_freq}{Boolean: Sort output by word frequency? 
Default: \code{sort_freq = TRUE}.}
}
\value{
A named numeric vector.
}
\description{
Count the frequency of words in a string of text \code{x}.
}
\examples{
# Default: 
s3 <- c("A first sentence.", "The second sentence.", 
        "A third --- and also the final --- sentence.")
count_words(s3)  # case-sensitive, sorts by frequency 

# Options: 
count_words(s3, case_sense = FALSE)  # case insensitive
count_words(s3, sort_freq = FALSE)   # sorts alphabetically

}
\seealso{
\code{\link{count_chars}} for counting the frequency of characters;   
\code{\link{plot_text}} for a corresponding plot function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars}()},
\code{\link{l33t_rul35}},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
